/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.common;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;

public class TypedModelConfiguration {
    private final @NonNull Mode mode;
    private final @Nullable String name;
    private @Nullable TypedModel typedModel = null;

    public TypedModelConfiguration(@Nullable String name, @NonNull Mode mode) {
        this.name = name;
        this.mode = mode;
    }

    public TypedModelConfiguration(@NonNull TypedModel typedModel, @NonNull Mode mode) {
        this(typedModel.getName(), mode);
        this.typedModel = typedModel;
    }

    public @Nullable TypedModel basicGetTypedModel() {
        return this.typedModel;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public @NonNull TypedModel getTypedModel() {
        return (TypedModel)ClassUtil.nonNullState((Object)this.typedModel);
    }

    public boolean isInput() {
        return this.mode == Mode.INPUT;
    }

    public boolean isIntermediate() {
        return this.mode == Mode.INTERMEDIATE;
    }

    public boolean isOutput() {
        return this.mode == Mode.OUTPUT;
    }

    public boolean isUnused() {
        return this.mode == Mode.UNUSED;
    }

    public @Nullable String reconcile(@NonNull Iterable<@NonNull TypedModel> typedModels) {
        this.typedModel = (TypedModel)NameUtil.getNameable(typedModels, (String)this.name);
        return this.typedModel != null ? null : "No '" + this.name + "' TypedModel in " + typedModels.iterator().next().getTransformation();
    }

    public String toString() {
        return "\u00ab" + (Object)((Object)this.mode) + "\u00bb" + (this.typedModel != null ? this.typedModel.getName() : this.name);
    }

    public static enum Mode {
        INPUT,
        INTERMEDIATE,
        OUTPUT,
        UNUSED;

    }
}

