/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.qvt.declarative.ecore.utils.TracingOption;
import org.eclipse.qvt.declarative.editor.ui.format.DefaultFormatManager;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;

public class QVTEditorPlugin
extends EclipseUIPlugin {
    public static final String PLUGIN_ID = QVTEditorPlugin.class.getPackage().getName();
    public static final String ID = QVTEditorPlugin.class.getPackage().getName();
    public static final TracingOption ANNOTATION_CREATE = new TracingOption(PLUGIN_ID, "annotation/create");
    public static final TracingOption ANNOTATION_DELETE = new TracingOption(PLUGIN_ID, "annotation/delete");
    public static final TracingOption ANNOTATION_UPDATE = new TracingOption(PLUGIN_ID, "annotation/update");
    public static final TracingOption EDITOR_SAVE = new TracingOption(PLUGIN_ID, "editor/save");
    public static final TracingOption MARKER_CREATE = new TracingOption(PLUGIN_ID, "marker/create");
    public static final TracingOption MARKER_DELETE = new TracingOption(PLUGIN_ID, "marker/delete");
    public static final TracingOption RESOURCE_LOAD = new TracingOption(PLUGIN_ID, "resource/load");
    public static final TracingOption SELECTION_INNER = new TracingOption(PLUGIN_ID, "selection/inner");
    public static final TracingOption SELECTION_OUTER = new TracingOption(PLUGIN_ID, "selection/outer");
    public static final TracingOption VISITOR_SELECTION = new TracingOption(PLUGIN_ID, "visitor/selection");
    public static final TracingOption VISITOR_TRACE = new TracingOption(PLUGIN_ID, "visitor/trace");
    public static QVTEditorPlugin INSTANCE;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        DefaultFormatManager.initialize(DefaultFormatManager.INSTANCE);
    }

    public void stop(BundleContext context) throws Exception {
        INSTANCE = null;
        super.stop(context);
    }

    public static Status createErrorStatus(String string, Throwable e) {
        return new Status(4, PLUGIN_ID, 0, string, e);
    }

    public static QVTEditorPlugin getDefault() {
        return INSTANCE;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return QVTEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void logError(String string, Throwable e) {
        ILog log = INSTANCE.getLog();
        log.log((IStatus)QVTEditorPlugin.createErrorStatus(string, e));
    }

    public static void showError(final String string, final Exception e) {
        Display display = Display.getDefault();
        if (Thread.currentThread() != display.getThread()) {
            display.syncExec(new Runnable(){

                public void run() {
                    QVTEditorPlugin.showError(string, e);
                }
            });
        } else {
            ErrorDialog.openError(null, (String)"QVT Editor Error", null, (IStatus)QVTEditorPlugin.createErrorStatus(string, e));
        }
    }
}

