/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.util;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ImportToNonTransformCtxHelper;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtOperationalEvaluationVisitorImpl;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.HelperOperationCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonTransformationExecutionContext {
    private QvtOperationalEvaluationVisitorImpl fEvaluator;
    private LinkedHashSet<Module> fLibraryImports;

    public NonTransformationExecutionContext(Set<Module> libraryImports) {
        if (libraryImports == null) {
            throw new IllegalArgumentException();
        }
        this.fLibraryImports = new LinkedHashSet<Module>(libraryImports);
        Context context = new Context();
        ImportToNonTransformCtxHelper importProvider = new ImportToNonTransformCtxHelper(this.fLibraryImports, true);
        this.fEvaluator = QvtOperationalEvaluationVisitorImpl.createNonTransformationExecutionContextVisitor((Context)context, (ImportToNonTransformCtxHelper)importProvider);
    }

    public HelperOperationCall createHelperCall(Helper operation) {
        if (operation == null) {
            throw new IllegalArgumentException("null operation");
        }
        Module owningModule = QvtOperationalParserUtil.getOwningModule((ImperativeOperation)operation);
        if (owningModule == null || owningModule != QvtOperationalStdLibrary.INSTANCE.getStdLibModule() && !this.fLibraryImports.contains(owningModule)) {
            throw new IllegalArgumentException("Operation not imported from a library");
        }
        return new HelperOperationCall(operation, this);
    }

    public void dispose() {
    }

    QvtOperationalEvaluationVisitorImpl getEvaluator() {
        return this.fEvaluator;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Module importedLib : this.fLibraryImports) {
            buf.append(importedLib.getName());
        }
        return buf.toString();
    }
}

