/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.nblocking;

import java.math.BigInteger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.RequestStatus;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.MetaInformation;
import org.eclipse.om2m.commons.entities.RequestEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.resource.Request;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.nblocking.NonBlockingWorker;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class NonBlockingHandler {
    private static ExecutorService poolThread = Executors.newFixedThreadPool(10);
    private static Log LOGGER = LogFactory.getLog(NonBlockingHandler.class);

    private NonBlockingHandler() {
    }

    public static ResponsePrimitive handle(RequestPrimitive request) {
        LOGGER.info((Object)"Non blocking request received, building request object...");
        DBService dbs = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        CSEBaseEntity cseBaseEntity = (CSEBaseEntity)dbs.getDAOFactory().getCSEBaseDAO().find(transaction, (Object)("/" + Constants.CSE_ID));
        ResponsePrimitive response = new ResponsePrimitive(request);
        RequestEntity requestEntity = new RequestEntity();
        try {
            if (request.getContent() != null) {
                if (request.getRequestContentType().equals("application/obj")) {
                    requestEntity.setContent(DataMapperSelector.getDataMapperList().get("application/json").objToString(request.getContent()));
                    requestEntity.setRequestContentType("application/json");
                } else if (request.getContent() instanceof String && !((String)request.getContent()).isEmpty()) {
                    if (!request.getRequestContentType().equals("application/json")) {
                        Object resource = DataMapperSelector.getDataMapperList().get(request.getReturnContentType()).stringToObj((String)request.getContent());
                        requestEntity.setContent(DataMapperSelector.getDataMapperList().get("application/json").objToString(resource));
                        requestEntity.setRequestContentType(request.getRequestContentType());
                    } else {
                        requestEntity.setContent((String)request.getContent());
                        requestEntity.setRequestContentType(request.getRequestContentType());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BadRequestException("Error in provided content", (Throwable)e);
        }
        requestEntity.setCreationTime(Util.DateUtil.now());
        String requestIdentifier = Controller.generateId();
        requestEntity.setName("req_" + requestIdentifier);
        requestEntity.setHierarchicalURI(String.valueOf(cseBaseEntity.getHierarchicalURI()) + "/" + requestEntity.getName());
        requestEntity.setResourceID("/" + Constants.CSE_ID + "/" + "req" + Constants.PREFIX_SEPERATOR + requestIdentifier);
        requestEntity.setLastModifiedTime(Util.DateUtil.now());
        MetaInformation metaInf = new MetaInformation();
        metaInf.setDeliveryAggregation(request.isDeliveryAggregation());
        metaInf.setDiscoveryResultType(request.getDiscoveryResultType());
        metaInf.setGroupRequestIdentifier(request.getGroupRequestIdentifier());
        metaInf.setName(request.getName());
        metaInf.setOperationalExecutionTime(request.getOperationExecutionTime());
        metaInf.setOriginatingTimestamp(request.getOriginatingTimestamp());
        metaInf.setRequestExpirationTimestamp(request.getResultExpirationTimestamp());
        metaInf.setResourceType(request.getResourceType());
        metaInf.setResponseType(request.getResponseTypeInfo().getResponseType());
        metaInf.setResultContent(request.getResultContent());
        metaInf.setResultExpirationTimestamp(request.getResultExpirationTimestamp());
        if (request.getResultPersistence() != null) {
            metaInf.setResultPersistence(request.getResultPersistence().toString());
        }
        requestEntity.setMetaInformation(metaInf);
        requestEntity.setOperation(request.getOperation());
        requestEntity.setOriginator(request.getFrom());
        requestEntity.setParentID(cseBaseEntity.getResourceID());
        requestEntity.setResourceType(17);
        requestEntity.setReturnContentType(request.getReturnContentType());
        requestEntity.setStateTag(BigInteger.valueOf(0L));
        requestEntity.setTarget(request.getTo());
        requestEntity.setRequestID(requestIdentifier);
        requestEntity.setRequestStatus(RequestStatus.PENDING);
        UriMapper.addNewUri(requestEntity.getHierarchicalURI(), requestEntity.getResourceID(), 17);
        dbs.getDAOFactory().getRequestEntityDAO().create(transaction, (Object)requestEntity);
        RequestEntity requestDb = (RequestEntity)dbs.getDAOFactory().getRequestEntityDAO().find(transaction, (Object)requestEntity.getResourceID());
        cseBaseEntity.getChildReq().add(requestDb);
        dbs.getDAOFactory().getCSEBaseDAO().update(transaction, (Object)cseBaseEntity);
        transaction.commit();
        Request requestResource = EntityMapperFactory.getRequestMapper().mapEntityToResource(requestEntity, ResultContent.ATTRIBUTES);
        response.setContent((Object)requestResource.getResourceID());
        response.setContentType("text/plain");
        response.setResponseStatusCode(ResponseStatusCode.ACCEPTED);
        response.setLocation(requestDb.getResourceID());
        poolThread.execute(new NonBlockingWorker(requestEntity.getResourceID(), request));
        transaction.close();
        return response;
    }
}

