/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.binding.http;

import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.binding.http.RestHttpClient;
import org.eclipse.om2m.binding.http.RestHttpServlet;
import org.eclipse.om2m.binding.service.RestClientService;
import org.eclipse.om2m.core.service.CseService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private static Log LOGGER;
    private ServiceTracker<Object, Object> httpServiceTracker;
    private ServiceTracker<Object, Object> cseServiceTracker;
    protected static final String CSE_BASE_CONTEXT;

    static {
        LOGGER = LogFactory.getLog(Activator.class);
        CSE_BASE_CONTEXT = System.getProperty("org.eclipse.om2m.cseBaseContext", "/om2m");
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        LOGGER.info((Object)"Register HTTP RestClientService..");
        bundleContext.registerService(RestClientService.class.getName(), (Object)new RestHttpClient(), null);
        LOGGER.info((Object)"HTTP RestClientService is registered.");
        this.httpServiceTracker = new ServiceTracker<Object, Object>(bundleContext, HttpService.class.getName(), null){

            public void removedService(ServiceReference<Object> reference, Object service) {
                LOGGER.info((Object)"HttpService removed");
                try {
                    LOGGER.info((Object)("Unregister " + CSE_BASE_CONTEXT + " http context"));
                    ((HttpService)service).unregister(CSE_BASE_CONTEXT);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Object)"Error unregistring SclServlet", (Throwable)e);
                }
            }

            public Object addingService(ServiceReference<Object> reference) {
                LOGGER.info((Object)"HttpService discovered");
                HttpService httpService = (HttpService)this.context.getService(reference);
                try {
                    LOGGER.info((Object)("Register " + CSE_BASE_CONTEXT + " context"));
                    httpService.registerServlet(CSE_BASE_CONTEXT, (Servlet)new RestHttpServlet(), null, null);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error registering CseServlet", (Throwable)e);
                }
                return httpService;
            }
        };
        this.httpServiceTracker.open();
        this.cseServiceTracker = new ServiceTracker<Object, Object>(bundleContext, CseService.class.getName(), null){

            public void removedService(ServiceReference<Object> reference, Object service) {
                LOGGER.info((Object)"CseService removed");
                try {
                    RestHttpServlet.setCse(null);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Object)"Error removing SclService", (Throwable)e);
                }
            }

            public Object addingService(ServiceReference<Object> reference) {
                LOGGER.info((Object)"CseService discovered");
                CseService cse = (CseService)this.context.getService(reference);
                try {
                    RestHttpServlet.setCse(cse);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error adding SclService", (Throwable)e);
                }
                return cse;
            }
        };
        this.cseServiceTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }

    protected static BundleContext getContext() {
        return context;
    }
}

