/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.math.BigInteger;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.ContentInstanceEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.entitymapper.ContentInstanceMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class ContainerMapper
extends EntityMapper<ContainerEntity, Container> {
    @Override
    protected Container createResource() {
        return new Container();
    }

    @Override
    protected void mapAttributes(ContainerEntity entity, Container resource) {
        resource.setCreator(entity.getCreator());
        resource.setCurrentByteSize(BigInteger.valueOf(entity.getCurrentByteSize()));
        resource.setCurrentNrOfInstances(BigInteger.valueOf(entity.getChildContentInstances().size()));
        resource.setLocationID(entity.getLocationID());
        resource.setMaxByteSize(entity.getMaxByteSize());
        resource.setMaxInstanceAge(entity.getMaxInstanceAge());
        resource.setMaxNrOfInstances(entity.getMaxNrOfInstances());
        resource.setOntologyRef(entity.getOntologyRef());
        resource.setStateTag(entity.getStateTag());
        resource.setExpirationTime(entity.getExpirationTime());
        if (!entity.getAnnouncedAttribute().isEmpty()) {
            resource.getAnnouncedAttribute().addAll(entity.getAnnouncedAttribute());
        }
        if (!entity.getAnnounceTo().isEmpty()) {
            resource.getAnnounceTo().addAll(entity.getAnnounceTo());
        }
        for (AccessControlPolicyEntity acp : entity.getAccessControlPolicies()) {
            resource.getAccessControlPolicyIDs().add(acp.getResourceID());
        }
        resource.setOldest(String.valueOf(entity.getHierarchicalURI()) + "/" + "ol");
        resource.setLatest(String.valueOf(entity.getHierarchicalURI()) + "/" + "la");
    }

    @Override
    protected void mapChildResourceRef(ContainerEntity entity, Container resource) {
        ChildResourceRef child;
        for (ContentInstanceEntity cin : entity.getChildContentInstances()) {
            child = new ChildResourceRef();
            child.setResourceName(cin.getName());
            child.setType(4);
            child.setValue(cin.getResourceID());
            resource.getChildResource().add(child);
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            child = new ChildResourceRef();
            child.setResourceName(sub.getName());
            child.setType(23);
            child.setValue(sub.getResourceID());
            resource.getChildResource().add(child);
        }
        for (ContainerEntity childCont : entity.getChildContainers()) {
            child = new ChildResourceRef();
            child.setResourceName(childCont.getName());
            child.setType(3);
            child.setValue(childCont.getResourceID());
            resource.getChildResource().add(child);
        }
    }

    @Override
    protected void mapChildResources(ContainerEntity entity, Container resource) {
        for (ContentInstanceEntity cin : entity.getChildContentInstances()) {
            ContentInstance cinRes = (ContentInstance)new ContentInstanceMapper().mapEntityToResource(cin, ResultContent.ATTRIBUTES);
            resource.getContentInstanceOrContainerOrSubscription().add(cinRes);
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES);
            resource.getContentInstanceOrContainerOrSubscription().add(subRes);
        }
        for (ContainerEntity childCont : entity.getChildContainers()) {
            Container cnt = (Container)new ContainerMapper().mapEntityToResource(childCont, ResultContent.ATTRIBUTES);
            resource.getContentInstanceOrContainerOrSubscription().add(cnt);
        }
    }
}

