/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.om2m.sdt.Arg;
import org.eclipse.om2m.sdt.Device;
import org.eclipse.om2m.sdt.Element;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.types.DataType;

public class Action
extends Element {
    private boolean optional = false;
    private Map<String, Arg> args = new HashMap<String, Arg>();
    private DataType type;
    private final String definition;
    private final String longDefinitionName;
    private final String shortDefinitionName;
    private Device owner;
    private Module parent;

    public Action(String id, Identifiers identifiers) {
        super(String.valueOf(identifiers.getDefinition()) + "__" + id);
        this.definition = identifiers.getDefinition();
        this.longDefinitionName = identifiers.getLongName();
        this.shortDefinitionName = identifiers.getShortName();
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getLongDefinitionName() {
        return this.longDefinitionName;
    }

    public String getShortDefinitionName() {
        return this.shortDefinitionName;
    }

    public DataType getDataType() {
        return this.type;
    }

    public void setDataType(DataType type) {
        this.type = type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public Collection<String> getArgNames() {
        return this.args.keySet();
    }

    public Collection<Arg> getArgs() {
        return this.args.values();
    }

    public Arg getArg(String name) {
        return this.args.get(name);
    }

    public void addArg(Arg arg) {
        this.args.put(arg.getName(), arg);
    }

    public void removeArg(String name) {
        this.args.remove(name);
    }

    @Override
    protected String prettyPrint(String t1) {
        String t2 = String.valueOf(t1) + "\t";
        StringBuffer ret = new StringBuffer(t1).append("<Action name=\"").append(this.getName()).append("\">");
        if (this.getDoc() != null) {
            ret.append("\n").append(t2).append(this.getDoc());
        }
        if (this.type != null) {
            ret.append("\n").append(this.type.prettyPrint(t2));
        }
        this.prettyPrint(ret, this.args.values(), "Args", t2);
        return ret.append("\n").append(t1).append("</Action>").toString();
    }

    void setOwner(Device owner) {
        this.owner = owner;
    }

    public Device getOwner() {
        return this.owner;
    }

    void setParent(Module parent) {
        this.parent = parent;
    }

    public Module getParent() {
        return this.parent;
    }
}

