/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.webapp.resourcesbrowser.json;

import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.webapp.resourcesbrowser.json.WelcomeServlet;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Log LOGGER = LogFactory.getLog(Activator.class);
    public static String globalContext = System.getProperty("org.eclipse.om2m.globalContext", "");
    public static String uiContext = System.getProperty("org.eclipse.om2m.webInterfaceContext", "/");
    public static String sep = "/";
    private ServiceTracker<Object, Object> httpServiceTracker;

    public void start(BundleContext context) throws Exception {
        if (uiContext.equals("/")) {
            sep = "";
        }
        this.httpServiceTracker = new ServiceTracker<Object, Object>(context, HttpService.class.getName(), null){

            public void removedService(ServiceReference<Object> reference, Object service) {
                LOGGER.info((Object)"HttpService removed");
                try {
                    LOGGER.info((Object)("Unregister " + uiContext + " http context"));
                    ((HttpService)service).unregister(uiContext);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Object)"Error unregistring webapp servlet", (Throwable)e);
                }
            }

            public Object addingService(ServiceReference<Object> reference) {
                LOGGER.info((Object)"HttpService discovered");
                HttpService httpService = (HttpService)this.context.getService(reference);
                try {
                    LOGGER.info((Object)("Register " + uiContext + " http context"));
                    httpService.registerServlet(uiContext, (Servlet)new WelcomeServlet(), null, null);
                    httpService.registerResources(String.valueOf(uiContext) + sep + "welcome", "/webapps", null);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error registring webapp servlet", (Throwable)e);
                }
                return httpService;
            }
        };
        this.httpServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
    }
}

