/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.datamapping.jaxb;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.URIList;
import org.eclipse.om2m.datamapping.service.DataMapperService;

public class Mapper
implements DataMapperService {
    private static Log LOGGER = LogFactory.getLog(Mapper.class);
    private JAXBContext context;
    private String resourcePackage = "org.eclipse.om2m.commons.resource:org.eclipse.om2m.commons.resource.flexcontainerspec";
    private String mediaType;

    public Mapper(String mediaType) {
        this.mediaType = mediaType;
        try {
            if (this.context == null) {
                if (mediaType.equals("application/json")) {
                    ClassLoader classLoader = Mapper.class.getClassLoader();
                    InputStream iStreamJsonBinding = classLoader.getResourceAsStream("json-binding.json");
                    InputStream iStreamJsonBindingFlexcontainer = classLoader.getResourceAsStream("json-binding-flexcontainer.json");
                    ArrayList<InputStream> iStreamList = new ArrayList<InputStream>();
                    iStreamList.add(iStreamJsonBinding);
                    iStreamList.add(iStreamJsonBindingFlexcontainer);
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    properties.put("eclipselink-oxm-xml", iStreamList);
                    properties.put("eclipselink.media-type", "application/json");
                    this.context = JAXBContext.newInstance((String)this.resourcePackage, (ClassLoader)classLoader, properties);
                } else if (mediaType.equals("application/xml")) {
                    ClassLoader classLoader = Mapper.class.getClassLoader();
                    InputStream iStream = classLoader.getResourceAsStream("xml-binding.xml");
                    HashMap<String, InputStream> properties = new HashMap<String, InputStream>();
                    properties.put("eclipselink.oxm.metadata-source", iStream);
                    this.context = JAXBContext.newInstance((String)this.resourcePackage, (ClassLoader)classLoader, properties);
                } else {
                    this.context = JAXBContext.newInstance((String)this.resourcePackage, (ClassLoader)Mapper.class.getClassLoader());
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error((Object)"Create JAXBContext error", e);
        }
    }

    public String objToString(Object obj) {
        try {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            marshaller.setProperty("eclipselink.media-type", (Object)this.mediaType);
            if (obj instanceof URIList) {
                marshaller.setProperty("eclipselink.json.include-root", (Object)false);
                marshaller.setProperty("eclipselink.json.marshal-empty-collections", (Object)true);
                marshaller.setProperty("eclipselink.json.reduce-any-arrays", (Object)false);
            } else {
                marshaller.setProperty("eclipselink.json.include-root", (Object)true);
                marshaller.setProperty("eclipselink.json.marshal-empty-collections", (Object)false);
                marshaller.setProperty("eclipselink.json.reduce-any-arrays", (Object)true);
            }
            marshaller.setProperty("eclipselink.json.value-wrapper", (Object)"val");
            HashMap<String, String> namespaces = new HashMap<String, String>();
            namespaces.put("http://www.onem2m.org/xml/protocols/homedomain", "hd");
            namespaces.put("http://www.onem2m.org/xml/protocols", "m2m");
            marshaller.setProperty("eclipselink.namespace-prefix-mapper", namespaces);
            marshaller.setProperty("eclipselink.json.namespace-separator", (Object)Character.valueOf(':'));
            marshaller.marshal(obj, (OutputStream)outputStream);
            return ((Object)outputStream).toString();
        }
        catch (JAXBException e) {
            LOGGER.error((Object)"JAXB marshalling error!", (Throwable)e);
            return null;
        }
    }

    public Object stringToObj(String representation) {
        if (representation.isEmpty()) {
            return null;
        }
        StringReader stringReader = new StringReader(representation);
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            unmarshaller.setProperty("eclipselink.media-type", (Object)this.mediaType);
            if (representation.contains("m2m:uril")) {
                unmarshaller.setProperty("eclipselink.json.include-root", (Object)true);
                unmarshaller.setProperty("eclipselink.json.wrapper-as-array-name", (Object)true);
            } else {
                unmarshaller.setProperty("eclipselink.json.include-root", (Object)true);
                unmarshaller.setProperty("eclipselink.json.wrapper-as-array-name", (Object)false);
            }
            unmarshaller.setProperty("eclipselink.json.value-wrapper", (Object)"val");
            HashMap<String, String> namespaces = new HashMap<String, String>();
            namespaces.put("http://www.onem2m.org/xml/protocols/homedomain", "hd");
            namespaces.put("http://www.onem2m.org/xml/protocols", "m2m");
            unmarshaller.setProperty("eclipselink.namespace-prefix-mapper", namespaces);
            unmarshaller.setProperty("eclipselink.json.namespace-separator", (Object)Character.valueOf(':'));
            unmarshaller.setListener(new Unmarshaller.Listener(){

                public void afterUnmarshal(Object target, Object parent) {
                    System.out.println("afterUnmarshal (target=" + target + ", parent=" + parent + ")");
                    super.afterUnmarshal(target, parent);
                    if (target instanceof AbstractFlexContainer) {
                        ((AbstractFlexContainer)target).finalizeDeserialization();
                    }
                }
            });
            Object unmarshaledObject = unmarshaller.unmarshal((Reader)stringReader);
            Object toBeReturned = null;
            toBeReturned = unmarshaledObject;
            return toBeReturned;
        }
        catch (JAXBException e) {
            LOGGER.error((Object)"JAXB unmarshalling error!", (Throwable)e);
            return null;
        }
    }

    public String getServiceDataType() {
        return this.mediaType;
    }
}

