/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt;

import java.util.List;
import org.eclipse.om2m.commons.constants.AccessControl;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AEAnnc;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.AccessControlRule;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.SetOfAcrs;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.service.CseService;

public class CseUtil {
    public static ResponsePrimitive sendCreateApplicationEntityRequest(CseService cseService, AE ae, String resourceLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(resourceLocation);
        request.setOperation(Operation.CREATE);
        request.setRequestContentType("application/obj");
        request.setResourceType(2);
        request.setReturnContentType("application/obj");
        request.setContent((Object)ae);
        return CseUtil.sendRequest(cseService, request);
    }

    public static ResponsePrimitive sendUpdateApplicationAnncEntityRequest(CseService cseService, AEAnnc aeAnnc, String resourceLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(resourceLocation);
        request.setOperation(Operation.UPDATE);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setContent((Object)aeAnnc);
        return CseUtil.sendRequest(cseService, request);
    }

    public static ResponsePrimitive sendCreateSubscriptionRequest(CseService cseService, Subscription subscription, String resourceLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(resourceLocation);
        request.setOperation(Operation.CREATE);
        request.setRequestContentType("application/obj");
        request.setResourceType(23);
        request.setReturnContentType("application/obj");
        request.setContent((Object)subscription);
        return CseUtil.sendRequest(cseService, request);
    }

    public static ResponsePrimitive sendCreateFlexContainerRequest(CseService cseService, AbstractFlexContainer flexContainer, String resourceLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(resourceLocation);
        request.setOperation(Operation.CREATE);
        request.setRequestContentType("application/obj");
        request.setResourceType(28);
        request.setReturnContentType("application/obj");
        request.setContent((Object)flexContainer);
        return CseUtil.sendRequest(cseService, request);
    }

    public static ResponsePrimitive sendCreateDefaultACP(CseService cseService, String acpLocation, String acpName, List<String> labels) {
        AccessControlPolicy acp = new AccessControlPolicy();
        acp.setName(acpName);
        acp.getLabels().addAll(labels);
        SetOfAcrs setOfAcs = new SetOfAcrs();
        acp.setPrivileges(setOfAcs);
        AccessControlRule acr = new AccessControlRule();
        acr.setAccessControlOperations(AccessControl.ALL);
        acr.getAccessControlOriginators().add(Constants.ADMIN_REQUESTING_ENTITY);
        setOfAcs.getAccessControlRule().add(acr);
        acp.setSelfPrivileges(new SetOfAcrs());
        AccessControlRule acrSP = new AccessControlRule();
        acrSP.setAccessControlOperations(AccessControl.ALL);
        acrSP.getAccessControlOriginators().add(Constants.ADMIN_REQUESTING_ENTITY);
        acp.getSelfPrivileges().getAccessControlRule().add(acrSP);
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(acpLocation);
        request.setOperation(Operation.CREATE);
        request.setRequestContentType("application/obj");
        request.setResourceType(1);
        request.setReturnContentType("application/obj");
        request.setContent((Object)acp);
        return CseUtil.sendRequest(cseService, request);
    }

    public static ResponsePrimitive sendInternalNotifyFlexContainerRequest(CseService cseService, AbstractFlexContainer flexContainer, String resourceLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(resourceLocation);
        request.setOperation(Operation.INTERNAL_NOTIFY);
        request.setRequestContentType("application/obj");
        request.setResourceType(28);
        request.setReturnContentType("application/obj");
        request.setContent((Object)flexContainer);
        return CseUtil.sendRequest(cseService, request);
    }

    public static ResponsePrimitive sendRetrieveRequest(CseService cseService, String uri) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(uri);
        request.setOperation(Operation.RETRIEVE);
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        return CseUtil.sendRequest(cseService, request);
    }

    public static ResponsePrimitive sendDeleteRequest(CseService cseService, String resourceLocation) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(resourceLocation);
        request.setOperation(Operation.DELETE);
        return CseUtil.sendRequest(cseService, request);
    }

    private static ResponsePrimitive sendRequest(CseService cseService, RequestPrimitive request) {
        return cseService.doRequest(request);
    }
}

