/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.ipe.sdt.DeviceListListener;
import org.eclipse.om2m.sdt.Device;

public class DeviceList
implements DeviceListListener {
    private static final DeviceList INSTANCE = new DeviceList();
    private List<Device> devices = new ArrayList<Device>();
    private List<DeviceListListener> listeners = new ArrayList<DeviceListListener>();

    private DeviceList() {
    }

    public static DeviceList getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDevice(Device pDevice) {
        List<Device> list = this.devices;
        synchronized (list) {
            this.devices.add(pDevice);
            this.notifyNewDevice(pDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDevice(Device pDevice) {
        List<Device> list = this.devices;
        synchronized (list) {
            if (this.devices.remove(pDevice)) {
                this.notifyDeviceRemoved(pDevice);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Device> getDevices() {
        ArrayList<Device> toBeReturned = new ArrayList<Device>();
        List<Device> list = this.devices;
        synchronized (list) {
            toBeReturned.addAll(this.devices);
        }
        return toBeReturned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListenerAndSend(DeviceListListener listenerToBeAdded) {
        List<DeviceListListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listenerToBeAdded);
        }
        for (Device device : this.getDevices()) {
            try {
                listenerToBeAdded.notifyNewDevice(device);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceListListener> getListeners() {
        ArrayList<DeviceListListener> toBeReturned = new ArrayList<DeviceListListener>();
        List<DeviceListListener> list = this.listeners;
        synchronized (list) {
            toBeReturned.addAll(this.listeners);
        }
        return toBeReturned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DeviceListListener listenerToBeRemoved) {
        for (Device device : this.getDevices()) {
            try {
                listenerToBeRemoved.notifyDeviceRemoved(device);
            }
            catch (Exception exception) {}
        }
        List<DeviceListListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listenerToBeRemoved);
        }
    }

    @Override
    public void notifyNewDevice(Device newDevice) {
        for (DeviceListListener listener : this.getListeners()) {
            try {
                listener.notifyNewDevice(newDevice);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void notifyDeviceRemoved(Device toBeRemovedDevice) {
        for (DeviceListListener listener : this.getListeners()) {
            try {
                listener.notifyDeviceRemoved(toBeRemovedDevice);
            }
            catch (Exception exception) {}
        }
    }
}

