/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlOriginatorEntity;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AccessControlRuleEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.AccessDeniedException;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.Om2mException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.dynamicauthorization.DynamicAuthorizationSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;

public abstract class Controller {
    protected static Log LOGGER = LogFactory.getLog(Controller.class);
    protected DBService dbs;
    protected DBTransaction transaction;

    public ResponsePrimitive doRequest(RequestPrimitive request) throws Om2mException {
        ResponsePrimitive response;
        block14: {
            response = new ResponsePrimitive(request);
            this.dbs = PersistenceService.getInstance().getDbService();
            this.transaction = this.dbs.getDbTransaction();
            try {
                try {
                    this.transaction.open();
                    if (request.getOperation().equals(Operation.CREATE)) {
                        response = this.doCreate(request);
                        break block14;
                    }
                    if (request.getOperation().equals(Operation.RETRIEVE)) {
                        response = this.doRetrieve(request);
                        break block14;
                    }
                    if (request.getOperation().equals(Operation.UPDATE)) {
                        response = this.doUpdate(request);
                        break block14;
                    }
                    if (request.getOperation().equals(Operation.DELETE)) {
                        response = this.doDelete(request);
                        break block14;
                    }
                    if (request.getOperation().equals(Operation.INTERNAL_NOTIFY)) {
                        response = this.doInternalNotify(request);
                        break block14;
                    }
                    throw new BadRequestException("Incorrect Operation value (op): " + request.getOperation());
                }
                catch (Om2mException om2mException) {
                    LOGGER.error((Object)"om2mException", (Throwable)om2mException);
                    throw om2mException;
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Controller internal error", (Throwable)e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                LOGGER.info((Object)"Clear and close transaction");
                try {
                    this.transaction.commit();
                }
                catch (Exception exception) {}
                this.transaction.clear();
                this.transaction.close();
                throw throwable;
            }
        }
        LOGGER.info((Object)"Clear and close transaction");
        try {
            this.transaction.commit();
        }
        catch (Exception exception) {}
        this.transaction.clear();
        this.transaction.close();
        return response;
    }

    public abstract ResponsePrimitive doCreate(RequestPrimitive var1);

    public abstract ResponsePrimitive doRetrieve(RequestPrimitive var1);

    public abstract ResponsePrimitive doUpdate(RequestPrimitive var1);

    public abstract ResponsePrimitive doDelete(RequestPrimitive var1);

    public ResponsePrimitive doInternalNotify(RequestPrimitive request) {
        return null;
    }

    public void checkPermissions(RequestPrimitive request, ResourceEntity resource, List<AccessControlPolicyEntity> acpList) throws AccessDeniedException {
        try {
            this.checkACP(acpList, request.getFrom(), request.getOperation());
            return;
        }
        catch (AccessDeniedException accessDeniedException) {
            DynamicAuthorizationSelector.getInstance().authorize(this.dbs.getDBUtilManager().getDynamicAuthorizationConsultationUtil().getDynamicAuthorizationConsultations(resource.getResourceID()), request, resource);
            return;
        }
    }

    public void checkACP(String acpID, String originator, BigInteger method) throws AccessDeniedException {
        DBService db = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = db.getDbTransaction();
        transaction.open();
        if (!this.originatorExists(originator)) {
            throw new AccessDeniedException("Provided originator not found");
        }
        AccessControlPolicyEntity acp = (AccessControlPolicyEntity)db.getDAOFactory().getAccessControlPolicyDAO().find(transaction, (Object)acpID);
        if (acp == null) {
            throw new ResourceNotFoundException();
        }
        ArrayList<AccessControlPolicyEntity> acpList = new ArrayList<AccessControlPolicyEntity>();
        acpList.add(acp);
        this.checkACP(acpList, originator, method);
        transaction.close();
    }

    public void checkACP(List<AccessControlPolicyEntity> acpList, String originator, BigInteger operation) throws AccessDeniedException {
        if (originator == null) {
            throw new AccessDeniedException();
        }
        if (acpList == null || acpList.isEmpty()) {
            throw new AccessDeniedException("Current resource does not have any ACP attached");
        }
        boolean originatorFound = false;
        boolean operationAllowed = false;
        for (AccessControlPolicyEntity acp : acpList) {
            for (AccessControlRuleEntity rule : acp.getPrivileges()) {
                originatorFound = false;
                operationAllowed = false;
                for (AccessControlOriginatorEntity originatorEntity : rule.getAccessControlOriginators()) {
                    if (!originator.matches(originatorEntity.getOriginatorID().replace("*", ".*"))) continue;
                    originatorFound = true;
                    break;
                }
                if (originatorFound) {
                    if (operation.equals(Operation.CREATE) && rule.isCreate()) {
                        operationAllowed = true;
                    } else if (operation.equals(Operation.RETRIEVE) && rule.isRetrieve()) {
                        operationAllowed = true;
                    } else if (operation.equals(Operation.UPDATE) && rule.isUpdate()) {
                        operationAllowed = true;
                    } else if (operation.equals(Operation.DELETE) && rule.isDelete()) {
                        operationAllowed = true;
                    } else if (operation.equals(Operation.DISCOVERY) && rule.isDiscovery()) {
                        operationAllowed = true;
                    } else if (operation.equals(Operation.NOTIFY) && rule.isNotify()) {
                        operationAllowed = true;
                    }
                }
                if (originatorFound && operationAllowed) break;
            }
            if (originatorFound && operationAllowed) break;
        }
        if (!originatorFound) {
            throw new AccessDeniedException();
        }
        if (!operationAllowed) {
            throw new AccessDeniedException();
        }
    }

    public void checkSelfACP(AccessControlPolicyEntity acp, String originator, BigInteger operation) throws AccessDeniedException {
        boolean originatorFound = false;
        boolean operationAllowed = false;
        for (AccessControlRuleEntity rule : acp.getSelfPrivileges()) {
            originatorFound = false;
            operationAllowed = false;
            for (AccessControlOriginatorEntity originatorEntity : rule.getAccessControlOriginators()) {
                if (!originator.matches(originatorEntity.getOriginatorID().replace("*", ".*"))) continue;
                originatorFound = true;
                break;
            }
            if (originatorFound) {
                if (operation.equals(Operation.CREATE)) {
                    if (rule.isCreate()) {
                        operationAllowed = true;
                    }
                } else if (operation.equals(Operation.RETRIEVE)) {
                    if (rule.isRetrieve()) {
                        operationAllowed = true;
                    }
                } else if (operation.equals(Operation.UPDATE)) {
                    if (rule.isUpdate()) {
                        operationAllowed = true;
                    }
                } else if (operation.equals(Operation.DELETE)) {
                    if (rule.isDelete()) {
                        operationAllowed = true;
                    }
                } else if (operation.equals(Operation.DISCOVERY) && rule.isDiscovery()) {
                    operationAllowed = true;
                }
            }
            if (originatorFound && operationAllowed) break;
        }
        if (!originatorFound) {
            throw new AccessDeniedException();
        }
        if (!operationAllowed) {
            throw new AccessDeniedException();
        }
    }

    public static String generateId(String prefix, String postfix) {
        SecureRandom secureRandom = new SecureRandom();
        return String.valueOf(prefix) + String.valueOf(secureRandom.nextInt(999999999)) + postfix;
    }

    public static String generateId() {
        return Controller.generateId("", "");
    }

    protected void setLocationAndCreationContent(RequestPrimitive request, ResponsePrimitive response, ResourceEntity entity) {
        this.setLocationAndCreationContent(request, response, entity, EntityMapperFactory.getMapperFromResourceType(entity.getResourceType().intValue()));
    }

    protected void setLocationAndCreationContent(RequestPrimitive request, ResponsePrimitive response, ResourceEntity entity, EntityMapper mapper) {
        if (request.getResultContent() != null) {
            if (request.getResultContent().equals(ResultContent.HIERARCHICAL_ADRESS) || request.getResultContent().equals(ResultContent.HIERARCHICAL_AND_ATTRIBUTES)) {
                response.setLocation(entity.getHierarchicalURI());
            } else {
                response.setLocation(entity.getResourceID());
            }
            if (request.getResultContent().equals(ResultContent.HIERARCHICAL_AND_ATTRIBUTES) || request.getResultContent().equals(ResultContent.ATTRIBUTES)) {
                Object res = mapper.mapEntityToResource(entity, ResultContent.ATTRIBUTES, 0, 0);
                if (request.getReturnContentType().equals("application/obj")) {
                    response.setContent(res);
                } else {
                    String representation = DataMapperSelector.getDataMapperList().get(request.getReturnContentType()).objToString(res);
                    response.setContent((Object)representation);
                }
            }
        } else {
            response.setContent(mapper.mapEntityToResource(entity, ResultContent.ATTRIBUTES, 0, 0));
            response.setLocation(entity.getResourceID());
        }
    }

    protected boolean originatorExists(String originator) {
        boolean isValid = false;
        DBService db = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = db.getDbTransaction();
        transaction.open();
        AccessControlOriginatorEntity originatorEntity = (AccessControlOriginatorEntity)db.getDAOFactory().getAccessControlOriginatorDAO().find(transaction, (Object)originator);
        if (originatorEntity != null) {
            isValid = true;
        }
        transaction.close();
        return isValid;
    }

    protected void registerOriginator(String originator) {
        DBService db = PersistenceService.getInstance().getDbService();
        DBTransaction transaction = db.getDbTransaction();
        transaction.open();
        AccessControlOriginatorEntity originatorEntity = new AccessControlOriginatorEntity();
        originatorEntity.setOriginatorID(originator);
        db.getDAOFactory().getAccessControlOriginatorDAO().create(transaction, (Object)originatorEntity);
        transaction.commit();
        transaction.close();
    }
}

