/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.Action;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.args.Command;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.ActionException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.actions.DownVolume;
import org.eclipse.om2m.sdt.home.actions.UpVolume;
import org.eclipse.om2m.sdt.home.types.ActionType;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class AudioVolume
extends Module {
    private BooleanDataPoint muteEnabled;
    private IntegerDataPoint volumePercentage;
    private IntegerDataPoint stepValue;
    private IntegerDataPoint maxValue;
    private Action upVolume;
    private Action downVolume;

    public AudioVolume(String name, Domain domain, IntegerDataPoint volumePercentage, BooleanDataPoint muteEnabled) {
        super(name, domain, (Identifiers)ModuleType.audioVolume);
        if (muteEnabled == null || !muteEnabled.getShortDefinitionType().equals(DatapointType.muteEnabled.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong muteEnabled datapoint: " + muteEnabled);
        }
        this.muteEnabled = muteEnabled;
        this.muteEnabled.setDoc("The current status of the mute enablement. \"True\" indicates enabaled, and \"False\" indicates not enabled.");
        this.addDataPoint((DataPoint)this.muteEnabled);
        if (volumePercentage == null || !volumePercentage.getShortDefinitionType().equals(DatapointType.volumePercentage.getShortName())) {
            throw new IllegalArgumentException("Wrong volumePercentage datapoint: " + volumePercentage);
        }
        this.volumePercentage = volumePercentage;
        this.volumePercentage.setDoc("The rounded percentage of the current volume in the range of [0, maxValue]. 0% shall mean no sound produced.");
        this.addDataPoint((DataPoint)this.volumePercentage);
    }

    public AudioVolume(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (IntegerDataPoint)dps.get(DatapointType.volumePercentage.getShortName()), (BooleanDataPoint)dps.get(DatapointType.muteEnabled.getShortName()));
        IntegerDataPoint maxValue;
        IntegerDataPoint stepValue = (IntegerDataPoint)dps.get(DatapointType.stepValue.getShortName());
        if (stepValue != null) {
            this.setStepValue(stepValue);
        }
        if ((maxValue = (IntegerDataPoint)dps.get(DatapointType.maxValue.getShortName())) != null) {
            this.setMaxValue(maxValue);
        }
    }

    public void addAction(Action action) {
        if (action.getShortDefinitionName().equals(ActionType.upVolume.getShortName())) {
            this.upVolume = action;
            super.addAction(this.upVolume);
        } else if (action.getShortDefinitionName().equals(ActionType.downVolume.getShortName())) {
            this.downVolume = action;
            super.addAction(this.downVolume);
        } else {
            throw new IllegalArgumentException("Wrong toggle action: " + action);
        }
    }

    public void setUpVolume(UpVolume upVolume) {
        this.addAction((Action)upVolume);
    }

    public void setDownVolume(DownVolume downVolume) {
        this.addAction((Action)downVolume);
    }

    public void upVolume() throws ActionException, AccessException {
        if (this.upVolume == null) {
            throw new ActionException("Not implemented");
        }
        ((Command)this.upVolume).invoke(null);
    }

    public void downVolume() throws ActionException, AccessException {
        if (this.downVolume == null) {
            throw new ActionException("Not implemented");
        }
        ((Command)this.downVolume).invoke(null);
    }

    public boolean getMuteEnabled() throws DataPointException, AccessException {
        return (Boolean)this.muteEnabled.getValue();
    }

    public void setMuteEnabled(boolean v) throws DataPointException, AccessException {
        this.muteEnabled.setValue((Object)v);
    }

    public int getVolumePercentage() throws DataPointException, AccessException {
        return (Integer)this.volumePercentage.getValue();
    }

    public void setVolumePercentage(int v) throws DataPointException, AccessException {
        this.volumePercentage.setValue((Object)v);
    }

    public void setStepValue(IntegerDataPoint sv) {
        this.stepValue = sv;
        this.stepValue.setWritable(false);
        this.stepValue.setOptional(true);
        this.stepValue.setDoc("Step value used by UpVolume and DownVolume.");
        this.addDataPoint((DataPoint)this.stepValue);
    }

    public int getStepValue() throws DataPointException, AccessException {
        if (this.stepValue == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.stepValue.getValue();
    }

    public void setMaxValue(IntegerDataPoint mv) {
        this.maxValue = mv;
        this.maxValue.setWritable(false);
        this.maxValue.setOptional(true);
        this.maxValue.setDoc("Maximum value allowed for UpVolume.");
        this.addDataPoint((DataPoint)this.maxValue);
    }

    public int getMaxValue() throws DataPointException, AccessException {
        if (this.maxValue == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.maxValue.getValue();
    }
}

