/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.modules;

import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.modules.EnergyConsumption;
import org.eclipse.om2m.sdt.home.types.DatapointType;

public class MockedEnergyConsumption
extends EnergyConsumption {
    public MockedEnergyConsumption(String name, Domain domain, FloatDataPoint value) {
        super(name, domain, value);
        this.setAbsoluteEnergyConsumption(new FloatDataPoint((Identifiers)DatapointType.absoluteEnergyConsumption){

            public Float doGetValue() throws DataPointException {
                return new Float(Math.random() * 1000.0);
            }
        });
        this.setRoundingEnergyConsumption(new IntegerDataPoint((Identifiers)DatapointType.roundingEnergyConsumption){

            public Integer doGetValue() throws DataPointException {
                return new Integer((int)(Math.random() * 1000.0));
            }
        });
        this.setSignificantDigits(new IntegerDataPoint((Identifiers)DatapointType.significantDigits){
            private Integer dataPointValue;
            {
                this.dataPointValue = 1;
            }

            public void doSetValue(Integer value) throws DataPointException {
                this.dataPointValue = value;
            }

            public Integer doGetValue() throws DataPointException {
                return this.dataPointValue;
            }
        });
        this.setMultiplyingFactors(new IntegerDataPoint((Identifiers)DatapointType.multiplyingFactors){
            private Integer dataPointValue;
            {
                this.dataPointValue = 2;
            }

            public void doSetValue(Integer value) throws DataPointException {
                this.dataPointValue = value;
            }

            public Integer doGetValue() throws DataPointException {
                return this.dataPointValue;
            }
        });
        this.setVoltage(new FloatDataPoint((Identifiers)DatapointType.voltage){
            private Float dataPointValue;
            {
                this.dataPointValue = Float.valueOf(220.0f);
            }

            public Float doGetValue() throws DataPointException {
                return this.dataPointValue;
            }
        });
        this.setCurrent(new FloatDataPoint((Identifiers)DatapointType.current){
            private Float dataPointValue;
            {
                this.dataPointValue = Float.valueOf(0.0f);
            }

            public Float doGetValue() throws DataPointException {
                return this.dataPointValue;
            }
        });
        this.setFrequency(new FloatDataPoint((Identifiers)DatapointType.frequency){
            private Float dataPointValue;
            {
                this.dataPointValue = Float.valueOf(50.0f);
            }

            public Float doGetValue() throws DataPointException {
                return this.dataPointValue;
            }
        });
    }
}

