/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.om2m.sdt.Constraint;
import org.eclipse.om2m.sdt.Element;
import org.eclipse.om2m.sdt.types.Array;
import org.eclipse.om2m.sdt.types.SimpleType;

public class DataType
extends Element {
    public static final DataType Boolean = new DataType(SimpleType.Boolean);
    public static final DataType Byte = new DataType(SimpleType.Byte);
    public static final DataType Integer = new DataType(SimpleType.Integer);
    public static final DataType Float = new DataType(SimpleType.Float);
    public static final DataType String = new DataType(SimpleType.String);
    public static final DataType Enum = new DataType(SimpleType.Enum);
    public static final DataType Date = new DataType(SimpleType.Date);
    public static final DataType Time = new DataType(SimpleType.Time);
    public static final DataType Datetime = new DataType(SimpleType.Datetime);
    public static final DataType Blob = new DataType(SimpleType.Blob);
    public static final DataType Uri = new DataType(SimpleType.Uri);
    private String unitOfMeasure;
    private TypeChoice type;
    private Map<String, Constraint> constraints;

    public DataType(TypeChoice type) {
        super(type.getOneM2MType());
        this.type = type;
        this.constraints = new HashMap<String, Constraint>();
    }

    public static DataType getDataType(String name) {
        String s = name.trim();
        if (s.startsWith("[")) {
            DataType dt = DataType.getDataType(s.substring(1, s.length() - 1));
            return dt == null ? null : new DataType(new Array(dt));
        }
        SimpleType st = SimpleType.getSimpleType(s);
        if (st != null) {
            return new DataType(st);
        }
        return null;
    }

    public TypeChoice getTypeChoice() {
        return this.type;
    }

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public Collection<String> getConstraintNames() {
        return this.constraints.keySet();
    }

    public Collection<Constraint> getConstraints() {
        return this.constraints.values();
    }

    public Constraint getConstraint(String name) {
        return this.constraints.get(name);
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.put(constraint.getName(), constraint);
    }

    public void removeConstraint(String name) {
        this.constraints.remove(name);
    }

    @Override
    public String prettyPrint(String t1) {
        String t2 = java.lang.String.valueOf(t1) + "\t";
        StringBuffer ret = new StringBuffer(t1).append("<DataType>");
        if (this.getDoc() != null) {
            ret.append("\n").append(t2).append(this.getDoc());
        }
        ret.append("\n").append(t2).append(this.type);
        this.prettyPrint(ret, this.constraints.values(), "Constraints", t1);
        return ret.append("\n").append(t1).append("</DataType>").toString();
    }

    @Override
    public String toString() {
        return "<" + this.getClass().getSimpleName() + " name=" + this.name + " type=" + this.getTypeChoice().getOneM2MType() + "/>";
    }

    public static interface TypeChoice {
        public String getOneM2MType();

        public String toString(Object var1) throws Exception;

        public Object fromString(String var1) throws Exception;
    }
}

