/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.monitoring.util;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.sdt.home.monitoring.authentication.service.AuthenticationInfo;
import org.eclipse.om2m.sdt.home.monitoring.authentication.service.AuthenticationService;
import org.eclipse.om2m.sdt.home.monitoring.util.Constants;
import org.eclipse.om2m.sdt.home.monitoring.util.HttpSessionHelper;
import org.eclipse.om2m.sdt.home.monitoring.util.ResourceDiscovery;

public class AuthFillter
implements Constants {
    private static Log LOGGER = LogFactory.getLog(AuthFillter.class);

    public static void validateUserCredentials(HttpServletRequest request, HttpServletResponse response, List<AuthenticationService> authenticationServices) throws IOException {
        String name = "";
        String password = "";
        String bearer = null;
        String clientId = null;
        String serviceName = null;
        String sessionId = null;
        HttpSession httpSession = request.getSession();
        sessionId = httpSession.getId();
        if (request.getParameter("name") != null && request.getParameter("password") != null) {
            name = request.getParameter("name");
            password = request.getParameter("password");
            LOGGER.info((Object)("parameters " + name + "/" + password));
        } else if (request.getHeader("Authorization") != null) {
            LOGGER.info((Object)("Headers Authorization " + request.getHeader("Authorization") + "X-Requested-With" + request.getHeader("X-Requested-With")));
            response.addHeader("WWW-Authenticate", "Basic");
            response.addHeader("Authorization", request.getHeader("Authorization"));
            if (request.getHeader("X-Requested-With") != null) {
                response.addHeader("X-Requested-With", request.getHeader("X-Requested-With"));
            }
            String authHeader = request.getHeader("Authorization");
            String cred = new String(Base64.decodeBase64((byte[])authHeader.substring(6).getBytes()));
            int idx = cred.indexOf(":");
            name = cred.substring(0, idx);
            password = cred.substring(idx + 1);
            LOGGER.info((Object)("headers " + name + "/" + password));
        } else {
            serviceName = request.getParameter("serviceName");
            if (serviceName != null) {
                AuthenticationService as = AuthFillter.getAuthenticationService(serviceName, authenticationServices);
                if (as != null) {
                    AuthenticationInfo ai = as.getAuthenticationInfo(sessionId);
                    bearer = ai.getAccessToken();
                    clientId = ai.getClientId();
                    name = as.getEndUserInfo(sessionId).getUserId();
                }
            } else {
                LOGGER.info((Object)"void");
            }
        }
        boolean createNewSession = false;
        if (bearer != null) {
            createNewSession = true;
        } else {
            String result = ResourceDiscovery.validateUserCredentials(name, password);
            LOGGER.info((Object)("result=" + result));
            if (result != null) {
                createNewSession = true;
            }
        }
        if (createNewSession) {
            HttpSessionHelper sessionHelper = new HttpSessionHelper(httpSession);
            sessionHelper.setAuthenticationUser(Boolean.TRUE);
            sessionHelper.setName(name);
            sessionHelper.setPassword(password);
            sessionHelper.setBearer(bearer);
            sessionHelper.setClientId(clientId);
            sessionHelper.setServiceName(serviceName);
        }
        if (request.getHeader("X-Requested-With") != null) {
            response.addHeader("WWW-Authenticate", "Basic");
            LOGGER.info((Object)("X-Requested-With " + name + "/" + password));
            response.sendError(401, null);
            return;
        }
        LOGGER.info((Object)("authenticated " + name + "/" + password));
    }

    private static AuthenticationService getAuthenticationService(String name, List<AuthenticationService> authenticationServices) {
        for (AuthenticationService as : authenticationServices) {
            if (!name.equals(as.getServiceName())) continue;
            return as;
        }
        return null;
    }
}

