/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.dynamicauthorization;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.constants.SecurityInfoType;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.AccessDeniedException;
import org.eclipse.om2m.commons.resource.AccessControlRule;
import org.eclipse.om2m.commons.resource.DasInfo;
import org.eclipse.om2m.commons.resource.DynAuthDasRequest;
import org.eclipse.om2m.commons.resource.DynAuthDasResponse;
import org.eclipse.om2m.commons.resource.DynAuthTokenReqInfo;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.SecurityInfo;
import org.eclipse.om2m.commons.resource.SetOfAcrs;
import org.eclipse.om2m.core.redirector.Redirector;

public class DynamicAuthorizationSelector {
    protected static Log LOGGER = LogFactory.getLog(DynamicAuthorizationSelector.class);
    private static final DynamicAuthorizationSelector INSTANCE = new DynamicAuthorizationSelector();

    public static DynamicAuthorizationSelector getInstance() {
        return INSTANCE;
    }

    private DynamicAuthorizationSelector() {
    }

    public void authorize(List<DynamicAuthorizationConsultationEntity> dacesToBeUsed, RequestPrimitive request, ResourceEntity resourceEntity) throws AccessDeniedException {
        LOGGER.debug((Object)("authorize " + resourceEntity.getResourceID() + " to " + dacesToBeUsed));
        SecurityInfo securityInfo = new SecurityInfo();
        securityInfo.setSecurityInfoType(SecurityInfoType.DYNAMIC_AUTHORIZATION_REQUEST);
        securityInfo.setDasRequest(new DynAuthDasRequest());
        securityInfo.getDasRequest().setOperation(request.getOperation());
        securityInfo.getDasRequest().setOriginator(request.getFrom());
        securityInfo.getDasRequest().getTokenIDs().addAll(request.getTokens());
        securityInfo.getDasRequest().setTargetedResourceID(resourceEntity.getResourceID());
        securityInfo.getDasRequest().setTargetedResourceType(resourceEntity.getResourceType());
        HashMap<DynamicAuthorizationConsultationEntity, ArrayList<String>> tickets = new HashMap<DynamicAuthorizationConsultationEntity, ArrayList<String>>();
        for (DynamicAuthorizationConsultationEntity dace : dacesToBeUsed) {
            if (!dace.getDynamicAuthorizationEnabled().booleanValue()) continue;
            ArrayList<String> ticketsPerDAC = new ArrayList<String>();
            if (this.authorize(dace, securityInfo, resourceEntity, ticketsPerDAC, request)) {
                return;
            }
            tickets.put(dace, ticketsPerDAC);
        }
        DynAuthTokenReqInfo dynAuthTokenReqInfo = null;
        if (!dacesToBeUsed.isEmpty()) {
            dynAuthTokenReqInfo = new DynAuthTokenReqInfo();
            for (DynamicAuthorizationConsultationEntity dace : dacesToBeUsed) {
                DasInfo dasInfo = new DasInfo();
                dasInfo.setURI((String)dace.getDynamicAuthorizationPoA().get(0));
                dasInfo.setDasRequest(securityInfo.getDasRequest());
                List ticketsPerDac = (List)tickets.get(dace);
                dasInfo.getDasRequest().getTokenIDs().clear();
                dasInfo.getDasRequest().getTokenIDs().addAll(ticketsPerDac);
                dynAuthTokenReqInfo.getDasInfo().add(dasInfo);
            }
        }
        throw new AccessDeniedException(dynAuthTokenReqInfo);
    }

    private boolean authorize(DynamicAuthorizationConsultationEntity dace, SecurityInfo securityInfo, ResourceEntity resourceEntity, List<String> tokens, RequestPrimitive request) {
        List pointOfAccesses = dace.getDynamicAuthorizationPoA();
        LOGGER.debug((Object)("authorize " + resourceEntity.getResourceID() + " to " + pointOfAccesses));
        for (String pointOfAccess : pointOfAccesses) {
            RequestPrimitive notifyRequest = new RequestPrimitive();
            notifyRequest.setOperation(Operation.NOTIFY);
            notifyRequest.setTo(pointOfAccess);
            notifyRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
            notifyRequest.setContent((Object)securityInfo);
            notifyRequest.setRequestContentType("application/obj");
            notifyRequest.setReturnContentType("application/obj");
            ResponsePrimitive response = Redirector.retargetNotify(notifyRequest);
            if (ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
                DynAuthDasResponse.DynamicACPInfo dynamicAcpInfo;
                SecurityInfo responseSecurityInfo = (SecurityInfo)response.getContent();
                if (responseSecurityInfo == null) {
                    LOGGER.info((Object)"No SecurityInfo in response");
                    continue;
                }
                if (!SecurityInfoType.DYNAMIC_AUTHORIZATION_RESPONSE.equals(responseSecurityInfo.getSecurityInfoType())) {
                    LOGGER.info((Object)"Wrong SecurityInfo type in response");
                    continue;
                }
                if (responseSecurityInfo.getDasResponse().getTokens() != null) {
                    tokens.addAll(responseSecurityInfo.getDasResponse().getTokens());
                }
                if ((dynamicAcpInfo = responseSecurityInfo.getDasResponse().getDynamicACPInfo()) == null) {
                    LOGGER.info((Object)"No DynamicACPInfo in response");
                    continue;
                }
                try {
                    this.checkACPs(dynamicAcpInfo, securityInfo.getDasRequest().getOriginator(), securityInfo.getDasRequest().getOperation());
                    List rpts = responseSecurityInfo.getDasResponse().getTokens();
                    if (rpts != null && !rpts.isEmpty()) {
                        request.getTokens().clear();
                        request.getTokens().addAll(rpts);
                    }
                    LOGGER.debug((Object)"check OK");
                    return true;
                }
                catch (AccessDeniedException e) {
                    LOGGER.warn((Object)("check KO: " + e.getMessage()));
                    continue;
                }
            }
            LOGGER.info((Object)("KO response " + response.getResponseStatusCode()));
        }
        return false;
    }

    private void checkACPs(DynAuthDasResponse.DynamicACPInfo dynamicAcpInfo, String originator, BigInteger operation) throws AccessDeniedException {
        if (originator == null) {
            throw new AccessDeniedException("No originator");
        }
        if (dynamicAcpInfo == null) {
            throw new AccessDeniedException("dynamicAcpInfo is false");
        }
        SetOfAcrs setOfAcrs = dynamicAcpInfo.getGrantedPrivileges();
        if (setOfAcrs == null) {
            throw new AccessDeniedException("set of acrs is null");
        }
        for (AccessControlRule rule : setOfAcrs.getAccessControlRule()) {
            LOGGER.debug((Object)("check " + originator + " in " + rule.getAccessControlOriginators() + " and " + operation + " / " + rule.getAccessControlOperations()));
            if (!rule.getAccessControlOperations().equals(operation)) continue;
            for (String originatorRule : rule.getAccessControlOriginators()) {
                if (!originator.matches(originatorRule.replace("*", ".*"))) continue;
                return;
            }
        }
        throw new AccessDeniedException("originator not found or operation not allowed");
    }
}

