/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.dacis;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AEAnnc;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RemoteCSE;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.BinarySwitchFlexContainerAnnc;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;

public class FlexContainerAnncDacisTest
extends Test {
    public FlexContainerAnncDacisTest(CseService pCseService) {
        super("FlexContainerAnnc Dacis", pCseService);
    }

    @Override
    public void performTest() {
        DynamicAuthorizationConsultation dac = this.createDAS();
        if (dac == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create DAC");
            return;
        }
        RemoteCSE remoteCse = this.createRemoteCse();
        if (remoteCse == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create RemoteCse");
            return;
        }
        AEAnnc aeAnnc = this.createAeAnnc(remoteCse.getResourceID());
        if (aeAnnc == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create AeAnnc");
            return;
        }
        BinarySwitchFlexContainerAnnc toBeCreatedFlexContainerAnnc = new BinarySwitchFlexContainerAnnc();
        toBeCreatedFlexContainerAnnc.getDynamicAuthorizationConsultationIDs().add(dac.getResourceID());
        toBeCreatedFlexContainerAnnc.setLink("/FlexContainerAnnc" + UUID.randomUUID());
        toBeCreatedFlexContainerAnnc.setName("FlexContainerAnnc_" + UUID.randomUUID());
        RequestPrimitive createRequest = new RequestPrimitive();
        createRequest.setOperation(Operation.CREATE);
        createRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        createRequest.setTo(aeAnnc.getResourceID());
        createRequest.setRequestContentType("application/obj");
        createRequest.setReturnContentType("application/obj");
        createRequest.setResourceType(10028);
        createRequest.setContent((Object)toBeCreatedFlexContainerAnnc);
        ResponsePrimitive createResponse = this.getCseService().doRequest(createRequest);
        if (createResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("response is null");
            return;
        }
        if (!ResponseStatusCode.CREATED.equals(createResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create FlexContainerAnnc: expecting " + ResponseStatusCode.CREATED + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        BinarySwitchFlexContainerAnnc createdFlexContainerAnnc = null;
        try {
            createdFlexContainerAnnc = (BinarySwitchFlexContainerAnnc)createResponse.getContent();
        }
        catch (ClassCastException classCastException) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a FlexContainerAnnc");
            return;
        }
        if (!this.checkEquals(createdFlexContainerAnnc.getDynamicAuthorizationConsultationIDs(), toBeCreatedFlexContainerAnnc.getDynamicAuthorizationConsultationIDs(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        ResponsePrimitive retrieveResponse = this.retrieveEntity(createdFlexContainerAnnc.getResourceID());
        if (retrieveResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("retrieveResponse is null");
            return;
        }
        if (!ResponseStatusCode.OK.equals(retrieveResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve FlexContainerAnnc: expecting " + ResponseStatusCode.OK + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        BinarySwitchFlexContainerAnnc retrievedFlexContainerAnnc = null;
        try {
            retrievedFlexContainerAnnc = (BinarySwitchFlexContainerAnnc)retrieveResponse.getContent();
        }
        catch (ClassCastException classCastException) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a FlexContainerAnnc");
            return;
        }
        if (!this.checkEquals(retrievedFlexContainerAnnc.getDynamicAuthorizationConsultationIDs(), toBeCreatedFlexContainerAnnc.getDynamicAuthorizationConsultationIDs(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        RequestPrimitive deleteRequest = new RequestPrimitive();
        deleteRequest.setOperation(Operation.DELETE);
        deleteRequest.setTo(dac.getResourceID());
        deleteRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        ResponsePrimitive deleteResponse = this.getCseService().doRequest(deleteRequest);
        if (!ResponseStatusCode.DELETED.equals(deleteResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to delete DAC");
            return;
        }
        retrieveResponse = this.retrieveEntity(createdFlexContainerAnnc.getResourceID());
        if (retrieveResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("retrieveResponse is null");
            return;
        }
        if (!ResponseStatusCode.OK.equals(retrieveResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve FlexContainerAnnc: expecting " + ResponseStatusCode.OK + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        retrievedFlexContainerAnnc = null;
        try {
            retrievedFlexContainerAnnc = (BinarySwitchFlexContainerAnnc)retrieveResponse.getContent();
        }
        catch (ClassCastException classCastException) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a FlexContainerAnnc");
            return;
        }
        if (!this.checkEquals(retrievedFlexContainerAnnc.getDynamicAuthorizationConsultationIDs(), new ArrayList(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        this.setState(Test.State.OK);
    }
}

