/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.utils;

import org.eclipse.om2m.commons.constants.Constants;

public class UriUtil
implements Constants {
    private UriUtil() {
    }

    public static boolean isAbsoluteUri(String uri) {
        return uri.startsWith("//") || uri.startsWith("_");
    }

    public static boolean isSpRelativeUri(String uri) {
        return uri.startsWith("/") && !uri.startsWith("//") || uri.startsWith("~");
    }

    public static boolean isCseRelativeUri(String uri) {
        return !uri.startsWith("/") && !uri.startsWith("//") && !uri.startsWith("~") && !uri.startsWith("_");
    }

    public static boolean isCurrentSpDomain(String uri) {
        String aux = UriUtil.toAbsoluteUri(uri);
        return aux.startsWith("//" + Constants.M2M_SP_ID) || aux.startsWith("_" + Constants.M2M_SP_ID);
    }

    public static boolean isCurrentCse(String uri) {
        String aux = UriUtil.toSpRelativeUri(uri);
        return aux.startsWith("~/" + Constants.CSE_ID) || aux.startsWith("/" + Constants.CSE_ID);
    }

    public static String toAbsoluteUri(String uri) {
        if (UriUtil.isAbsoluteUri(uri)) {
            return uri;
        }
        if (UriUtil.isSpRelativeUri(uri)) {
            String cleanUri = uri.startsWith("~") ? uri.substring(1) : uri;
            return "//" + Constants.M2M_SP_ID + cleanUri;
        }
        return UriUtil.toAbsoluteUri(UriUtil.toSpRelativeUri(uri));
    }

    public static String toSpRelativeUri(String uri) {
        if (UriUtil.isSpRelativeUri(uri)) {
            return uri;
        }
        if (UriUtil.isAbsoluteUri(uri)) {
            String aux = uri.startsWith(Constants.PREFIX_SEPERATOR) ? uri.substring(1) : uri.substring(2);
            return aux.split(Constants.M2M_SP_ID)[1];
        }
        return "/" + Constants.CSE_ID + "/" + uri;
    }

    public static String toCseRelativeUri(String uri) {
        if (UriUtil.isCseRelativeUri(uri)) {
            return uri;
        }
        if (UriUtil.isSpRelativeUri(uri)) {
            String aux;
            String string = aux = uri.startsWith("~") ? uri.substring(1) : uri;
            if (aux.equals("/" + Constants.CSE_ID)) {
                return aux;
            }
            return aux.split("/" + Constants.CSE_ID + "/")[1];
        }
        return UriUtil.toCseRelativeUri(UriUtil.toSpRelativeUri(uri));
    }
}

