/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.hue.impl;

import java.io.StringReader;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.hue.api.HueDevice;
import org.eclipse.om2m.hue.impl.controller.HueConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class HueDeviceImpl
implements HueDevice,
HueConstants {
    private static Log Logger = LogFactory.getLog(HueDeviceImpl.class);
    protected Dictionary properties;
    private String xmlDescription;

    public HueDeviceImpl(String xml_description) {
        this.xmlDescription = xml_description;
        this.properties = new Hashtable();
        this.properties.put("DEVICE_CATEGORY", new String[]{"Hue"});
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xml_description)));
            NodeList nodeList = document.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1 && node.getNodeName().equals("root")) {
                    NodeList rootNodeList = node.getChildNodes();
                    int j = 0;
                    while (j < rootNodeList.getLength()) {
                        Node rootChildNode = rootNodeList.item(j);
                        if (rootChildNode.getNodeName().equals("URLBase")) {
                            this.properties.put("UPnP.presentationURL", rootChildNode.getTextContent());
                        } else if (rootChildNode.getNodeName().equals("device")) {
                            NodeList deviceChildNodeList = rootChildNode.getChildNodes();
                            int k = 0;
                            while (k < deviceChildNodeList.getLength()) {
                                Node deviceChildNode = deviceChildNodeList.item(k);
                                String tag = deviceChildNode.getNodeName();
                                String value = deviceChildNode.getTextContent();
                                if (tag.equalsIgnoreCase("friendlyName")) {
                                    this.properties.put("UPnP.device.friendlyName", value);
                                    this.properties.put("DEVICE_FRIENDLY_NAME", value);
                                } else if (tag.equalsIgnoreCase("manufacturer")) {
                                    this.properties.put("UPnP.device.manufacturer", value);
                                    this.properties.put("DEVICE_MANUFACTURER", value);
                                } else if (tag.equalsIgnoreCase("deviceType")) {
                                    this.properties.put("UPnP.device.type", value);
                                } else if (tag.equalsIgnoreCase("UDN")) {
                                    this.properties.put("UPnP.device.UDN", value);
                                    this.properties.put("service.pid", value);
                                } else if (tag.equalsIgnoreCase("modelDescription")) {
                                    this.properties.put("UPnP.device.modelDescription", value);
                                    this.properties.put("DEVICE_DESCRIPTION", value);
                                } else if (tag.equalsIgnoreCase("modelNumber")) {
                                    this.properties.put("UPnP.device.modelNumber", value);
                                } else if (tag.equalsIgnoreCase("modelName")) {
                                    this.properties.put("UPnP.device.modelName", value);
                                    this.properties.put("DEVICE_PRODUCT_CLASS", value);
                                } else if (tag.equalsIgnoreCase("modelURL")) {
                                    this.properties.put("UPnP.device.modelURL", value);
                                } else if (tag.equalsIgnoreCase("serialNumber")) {
                                    this.properties.put("UPnP.device.serialNumber", value);
                                    this.properties.put("DEVICE_SERIAL", value);
                                } else if (tag.equalsIgnoreCase("manufacturerURL")) {
                                    this.properties.put("UPnP.device.manufacturerURL", value);
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            Logger.debug((Object)("props: " + this.properties));
        }
        catch (Throwable e) {
            Logger.warn((Object)"Unknown Error", e);
        }
    }

    public Dictionary getProperties() {
        return this.properties;
    }

    public String getXmlDescription() {
        return this.xmlDescription;
    }
}

