/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.modules.AbstractAlarmSensor;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class SmokeSensor
extends AbstractAlarmSensor {
    private IntegerDataPoint detectedTime;

    public SmokeSensor(String name, Domain domain, BooleanDataPoint alarm) {
        super(name, domain, alarm, ModuleType.smokeSensor, "The detection of smoke.");
    }

    public SmokeSensor(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (BooleanDataPoint)dps.get(DatapointType.alarm.getShortName()));
        IntegerDataPoint detectedTime = (IntegerDataPoint)dps.get(DatapointType.detectedTime.getShortName());
        if (detectedTime != null) {
            this.setDetectedTime(detectedTime);
        }
    }

    public void setDetectedTime(IntegerDataPoint dp) {
        this.detectedTime = dp;
        this.detectedTime.setOptional(true);
        this.detectedTime.setDoc("The time the smoke is detected.");
        this.addDataPoint((DataPoint)this.detectedTime);
    }

    public int getDetectedTime() throws DataPointException, AccessException {
        if (this.detectedTime == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.detectedTime.getValue();
    }

    public void setDetectedTime(int v) throws DataPointException, AccessException {
        if (this.detectedTime == null) {
            throw new DataPointException("Not implemented");
        }
        this.detectedTime.setValue((Object)v);
    }
}

