/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.FlexContainer;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.ipe.sdt.Activator;
import org.eclipse.om2m.ipe.sdt.CseUtil;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.events.SDTEventListener;
import org.eclipse.om2m.sdt.events.SDTNotification;
import org.osgi.framework.ServiceRegistration;

public class ModuleSDTListener
implements SDTEventListener {
    private static Log logger = LogFactory.getLog(ModuleSDTListener.class);
    private final Module module;
    private final String moduleFlexContainerLocation;
    private ServiceRegistration<?> serviceRegistration;

    public ModuleSDTListener(Module pModule, String pModuleFlexContainerLocation) {
        this.module = pModule;
        this.moduleFlexContainerLocation = pModuleFlexContainerLocation;
    }

    public void register() {
        logger.info((Object)"registering as a SDTListener");
        if (this.serviceRegistration == null) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("sdt.domains.ids", "*");
            ((Dictionary)properties).put("sdt.devices.ids", this.module.getOwner().getId());
            ((Dictionary)properties).put("sdt.modules.names", this.module.getName());
            ((Dictionary)properties).put("sdt.datapoints.names", "*");
            ((Dictionary)properties).put("sdt.devices.definitions", "*");
            ((Dictionary)properties).put("sdt.modules.definitions", "*");
            this.serviceRegistration = Activator.registerSDTListener(this, properties);
            logger.info((Object)"register as a SDTListener - DONE");
        } else {
            logger.error((Object)"ModuleSDTListener has been previously registered!!!", null);
        }
    }

    public void unregister() {
        logger.info((Object)"unregistering as a SDTListener");
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    public void handleNotification(SDTNotification notif) {
        logger.info((Object)("receive a notification for " + notif.getDataPoint().getName() + ", value=" + notif.getValue()));
        FlexContainer toBeUpdated = new FlexContainer();
        CustomAttribute ca = new CustomAttribute();
        ca.setCustomAttributeName(notif.getDataPoint().getName());
        Object value = notif.getValue();
        ca.setCustomAttributeValue(value != null ? value.toString() : null);
        toBeUpdated.getCustomAttributes().add(ca);
        ResponsePrimitive response = CseUtil.sendInternalNotifyFlexContainerRequest((AbstractFlexContainer)toBeUpdated, this.moduleFlexContainerLocation);
        if (!ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            logger.info((Object)("unable to send INTERNAL NOTIFY request to flexContainer " + this.moduleFlexContainerLocation + " : " + response.getContent()), null);
        } else {
            logger.debug((Object)"INTERNAL NOTIFY request successfully performed");
        }
    }

    public void setAuthenticationThreadGroup(ThreadGroup group) {
    }
}

