/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.dal.driver.sample.fan.function;

import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.dal.driver.custom.functions.BaseFunction;
import org.eclipse.om2m.dal.driver.sample.Activator;
import org.osgi.service.dal.FunctionData;
import org.osgi.service.dal.FunctionEvent;
import org.osgi.service.dal.PropertyMetadata;
import org.osgi.service.dal.functions.Alarm;
import org.osgi.service.dal.functions.data.AlarmData;
import org.osgi.service.event.Event;

public class FaultDetection
extends BaseFunction
implements Alarm {
    private static Log LOGGER = LogFactory.getLog(FaultDetection.class);
    private AlarmMetadata metaData;
    private AlarmData alarm;

    public FaultDetection(String devUid, String funcId) {
        super(devUid, "faultdetection", funcId);
    }

    @Override
    protected void setupFuncProperties() {
        this.props.put("dal.function.version", "1.0");
        this.props.put("dal.function.description", "FaultDetection function");
        this.props.put("dal.function.property.names", new String[]{"alarm"});
    }

    @Override
    protected void setupPropertyMetadata() {
        this.metaData = new AlarmMetadata();
        this.propMetadatas.put("alarm", this.metaData);
    }

    @Override
    protected void setupOperationMetadata() {
    }

    public AlarmData getAlarm() {
        return this.alarm;
    }

    public void setAlarm(AlarmData alarm) {
        this.alarm = alarm;
        Activator.getEventAdmin().postEvent((Event)new FunctionEvent("org/osgi/service/dal/FunctionEvent/PROPERTY_CHANGED", this.uid, "alarm", (FunctionData)alarm));
        LOGGER.info((Object)("Function event (" + this.uid + "-" + this.alarm + ") is sent."));
    }

    private class AlarmMetadata
    implements PropertyMetadata {
        private Map<String, Object> metadatas = new Hashtable<String, Object>();

        public AlarmMetadata() {
            this.metadatas.put("access", new Integer(7));
            this.metadatas.put("description", "The alarm data of fault detection.");
        }

        public Map getMetadata(String unit) {
            return this.metadatas;
        }

        public FunctionData getStep(String unit) {
            return null;
        }

        public FunctionData[] getEnumValues(String unit) {
            return null;
        }

        public FunctionData getMinValue(String unit) {
            return null;
        }

        public FunctionData getMaxValue(String unit) {
            return null;
        }
    }
}

