/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sample.sdt.controller;

import org.eclipse.om2m.ipe.sample.sdt.model.SampleModel;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;

public class SampleController {
    public static void setLampState(String lampId, boolean value) throws DataPointException, AccessException {
        SampleModel.setLampState(lampId, value);
    }

    public static boolean getLampState(String lampId) throws DataPointException, AccessException {
        return SampleModel.getLampValue(lampId);
    }

    public static void toggleLamp(String lampId) throws DataPointException, AccessException {
        boolean newState = !SampleModel.getLampValue(lampId);
        SampleModel.setLampState(lampId, newState);
    }

    public static void setAllOn() throws DataPointException, AccessException {
        SampleModel.setLampState("LAMP_0", true);
        SampleModel.setLampState("LAMP_1", true);
    }

    public static void setAllOff() throws DataPointException, AccessException {
        SampleModel.setLampState("LAMP_0", false);
        SampleModel.setLampState("LAMP_1", false);
    }

    public static void toogleAll() throws DataPointException, AccessException {
        boolean newState = !SampleModel.getLampValue("LAMP_0") || !SampleModel.getLampValue("LAMP_1");
        SampleModel.setLampState("LAMP_0", newState);
        SampleModel.setLampState("LAMP_1", newState);
    }

    public static void setColor(int red, int green, int blue) throws DataPointException, AccessException {
        SampleModel.setColor(red, green, blue);
    }
}

