/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.driver.Logger;
import org.eclipse.om2m.sdt.home.driver.Utils;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedCamera;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDeviceNumberDevice;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDoor;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedLight;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedSwitchButton;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedThermometer;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedWeatherStation;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    private static final String PROTOCOL = "Mocked";
    private static final String MANUFACTURER = "MockedManufacturer";
    private static BundleContext context;
    public static Logger logger;
    private List<GenericDevice> devices;
    private Domain domain = new Domain("home");
    private boolean running;
    private int counter = (int)(Math.random() * 100.0);

    public void start(BundleContext ctxt) throws Exception {
        try {
            try {
                logger = new Logger(PROTOCOL);
                logger.setLogService((LogService)ctxt.getService(ctxt.getServiceReference(LogService.class.getName())));
            }
            catch (Exception exception) {}
            context = ctxt;
            this.running = true;
            this.devices = new ArrayList<GenericDevice>();
            this.devices.add((GenericDevice)new MockedLight(this.getId(), this.getSerial(), this.domain));
            this.devices.add((GenericDevice)new MockedDoor(this.getId(), this.getSerial(), this.domain, true));
            this.devices.add((GenericDevice)new MockedDoor(this.getId(), this.getSerial(), this.domain, false));
            this.devices.add((GenericDevice)new MockedCamera(this.getId(), this.getSerial(), this.domain));
            this.devices.add((GenericDevice)new MockedWeatherStation(this.getId(), this.getSerial(), this.domain));
            this.devices.add((GenericDevice)new MockedSwitchButton(this.getId(), this.getSerial(), this.domain));
            this.devices.add((GenericDevice)new MockedDeviceNumberDevice(this.getId(), this.getSerial(), this.domain));
            this.devices.add((GenericDevice)new MockedThermometer(this.getId(), this.getSerial(), this.domain));
            for (GenericDevice dev : this.devices) {
                this.install(dev);
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (Activator.this.running) {
                        MockedLight light = new MockedLight(Activator.this.getId(), Activator.this.getSerial(), Activator.this.domain);
                        Activator.this.devices.add(light);
                        logger.info("\n*************************************************");
                        logger.info("start new light " + light);
                        logger.info("\n*************************************************");
                        Activator.this.install((GenericDevice)light);
                        Activator.this.running = false;
                        try {
                            Thread.sleep(180000L);
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void install(GenericDevice dev) {
        String name = String.valueOf(dev.getClass().getSimpleName()) + " " + dev.getName();
        dev.setDeviceName(name);
        dev.setProtocol(PROTOCOL);
        dev.setDeviceManufacturer(MANUFACTURER);
        logger.info("register " + dev);
        ((MockedDevice)dev).registerDevice();
    }

    public void stop(BundleContext context) throws Exception {
        for (GenericDevice dev : this.devices) {
            logger.info("unregister " + dev);
            ((MockedDevice)dev).unregisterDevice();
        }
        this.devices.clear();
        context = null;
        this.running = false;
    }

    public static List<ServiceRegistration> register(GenericDevice device) {
        return Utils.register((GenericDevice)device, (BundleContext)context);
    }

    private final String getId() {
        return "mocked_" + this.counter;
    }

    private final String getSerial() {
        return "serial_mocked_" + this.counter++;
    }
}

