/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.progress.UIJob;
import org.eclipse.e4.ui.progress.internal.AbstractProgressViewer;
import org.eclipse.e4.ui.progress.internal.FinishedJobs;
import org.eclipse.e4.ui.progress.internal.GroupInfo;
import org.eclipse.e4.ui.progress.internal.JobInfo;
import org.eclipse.e4.ui.progress.internal.JobTreeElement;
import org.eclipse.e4.ui.progress.internal.ProgressContentProvider;
import org.eclipse.e4.ui.progress.internal.ProgressManager;
import org.eclipse.e4.ui.progress.internal.ProgressViewUpdater;

public class ProgressViewerContentProvider
extends ProgressContentProvider {
    protected AbstractProgressViewer progressViewer;
    private FinishedJobs.KeptJobsListener keptJobListener;
    private boolean showFinished;
    private FinishedJobs finishedJobs;

    public ProgressViewerContentProvider(AbstractProgressViewer structured, FinishedJobs finishedJobs, ProgressViewUpdater viewUpdater, ProgressManager progressManager, boolean debug, boolean showFinished) {
        super(viewUpdater, progressManager, debug);
        this.progressViewer = structured;
        this.finishedJobs = finishedJobs;
        this.showFinished = showFinished;
        if (showFinished) {
            finishedJobs.addListener(this.getKeptJobListener());
        }
    }

    private FinishedJobs.KeptJobsListener getKeptJobListener() {
        this.keptJobListener = new FinishedJobs.KeptJobsListener(){

            @Override
            public void finished(JobTreeElement jte) {
                final JobTreeElement element = jte;
                UIJob updateJob = new UIJob("Refresh finished"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ProgressViewerContentProvider.this.refresh(new Object[]{element});
                        return Status.OK_STATUS;
                    }

                    public boolean shouldSchedule() {
                        return !(this).ProgressViewerContentProvider.this.progressViewer.getControl().isDisposed();
                    }

                    public boolean shouldRun() {
                        return !(this).ProgressViewerContentProvider.this.progressViewer.getControl().isDisposed();
                    }
                };
                updateJob.setSystem(true);
                updateJob.schedule();
            }

            @Override
            public void removed(JobTreeElement jte) {
                final JobTreeElement element = jte;
                UIJob updateJob = new UIJob("Remove finished"){

                    @Override
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (element == null) {
                            ProgressViewerContentProvider.this.refresh();
                        } else {
                            ProgressViewerContentProvider.this.remove(new Object[]{element});
                        }
                        return Status.OK_STATUS;
                    }
                };
                updateJob.setSystem(true);
                updateJob.schedule();
            }
        };
        return this.keptJobListener;
    }

    @Override
    public void refresh() {
        this.progressViewer.refresh(true);
    }

    @Override
    public void refresh(Object[] elements) {
        Object[] objectArray = this.getRoots(elements, true);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object refresh = objectArray[n2];
            this.progressViewer.refresh(refresh, true);
            ++n2;
        }
    }

    @Override
    public Object[] getElements(Object inputElement) {
        Object[] elements = super.getElements(inputElement);
        if (!this.showFinished) {
            return elements;
        }
        JobTreeElement[] kept = this.finishedJobs.getKeptElements();
        if (kept.length == 0) {
            return elements;
        }
        HashSet<Object> all = new HashSet<Object>();
        all.addAll(Arrays.asList(elements));
        JobTreeElement[] jobTreeElementArray = kept;
        int n = kept.length;
        int n2 = 0;
        while (n2 < n) {
            JobTreeElement next = jobTreeElementArray[n2];
            if (next.getParent() == null || !all.contains(next.getParent())) {
                all.add(next);
            }
            ++n2;
        }
        return all.toArray();
    }

    private Object[] getRoots(Object[] elements, boolean subWithParent) {
        if (elements.length == 0) {
            return elements;
        }
        HashSet<JobTreeElement> roots = new HashSet<JobTreeElement>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            JobTreeElement jobTreeElement = (JobTreeElement)element;
            if (jobTreeElement.isJobInfo()) {
                GroupInfo group = ((JobInfo)jobTreeElement).getGroupInfo();
                if (group == null) {
                    roots.add(jobTreeElement);
                } else if (subWithParent) {
                    roots.add(group);
                }
            } else {
                roots.add(jobTreeElement);
            }
            ++n2;
        }
        return roots.toArray();
    }

    @Override
    public void add(Object[] elements) {
        this.progressViewer.add(elements);
    }

    @Override
    public void remove(Object[] elements) {
        this.progressViewer.remove(elements);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.keptJobListener != null) {
            this.finishedJobs.removeListener(this.keptJobListener);
        }
    }
}

