/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.splitteraddon;

import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.addons.splitteraddon.SplitHost;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;

public class SplitterAddon {
    private static final String DISABLE_SPLITTER_ADDON = "DisableSplitterAddon";
    @Inject
    EModelService ms;
    @Inject
    EPartService ps;
    @Inject
    MApplication app;

    @Inject
    @Optional
    private void subscribeTopicTagsChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        if (this.app.getTags().contains(DISABLE_SPLITTER_ADDON)) {
            return;
        }
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MPart)) {
            return;
        }
        MPart part = (MPart)changedObj;
        if (UIEvents.isADD((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"NewValue", (Object)"Split Horizontal")) {
                this.splitPart(part, true);
            } else if (UIEvents.contains((Event)event, (String)"NewValue", (Object)"Split Vertical")) {
                this.splitPart(part, false);
            }
        } else if (UIEvents.isREMOVE((Event)event)) {
            MCompositePart compPart = SplitterAddon.findContainingCompositePart(part);
            if (UIEvents.contains((Event)event, (String)"OldValue", (Object)"Split Horizontal")) {
                this.unsplitPart(compPart);
            } else if (UIEvents.contains((Event)event, (String)"OldValue", (Object)"Split Vertical")) {
                this.unsplitPart(compPart);
            }
        }
    }

    public static MCompositePart findContainingCompositePart(MPart part) {
        if (part == null) {
            return null;
        }
        MElementContainer curParent = part.getParent();
        while (curParent != null && !(curParent instanceof MCompositePart)) {
            curParent = curParent.getParent();
        }
        return (MCompositePart)curParent;
    }

    private void unsplitPart(MCompositePart compositePart) {
        if (compositePart == null) {
            return;
        }
        List innerElements = this.ms.findElements((MUIElement)compositePart, null, MPart.class, null);
        if (innerElements.size() < 3) {
            return;
        }
        MPart originalEditor = (MPart)innerElements.get(1);
        MPart clonedEditor = (MPart)innerElements.get(2);
        clonedEditor.setToBeRendered(false);
        MElementContainer compParent = compositePart.getParent();
        int index = compParent.getChildren().indexOf(compositePart);
        compParent.getChildren().remove(compositePart);
        originalEditor.getParent().getChildren().remove(originalEditor);
        compParent.getChildren().add(index, originalEditor);
        if (this.ps.getActivePart() == originalEditor) {
            this.ps.activate(null);
        }
        this.ps.activate(originalEditor);
    }

    private MCompositePart createCompositePart(MPart originalPart) {
        MCompositePart compPart = (MCompositePart)this.ms.createModelElement(MCompositePart.class);
        compPart.setElementId("Split Host(" + originalPart.getLabel() + ")");
        compPart.setLabel(originalPart.getLabel());
        compPart.setTooltip(originalPart.getTooltip());
        compPart.setIconURI(originalPart.getIconURI());
        compPart.setCloseable(true);
        compPart.setContributionURI(SplitHost.SPLIT_HOST_CONTRIBUTOR_URI);
        Object overriddenImage = originalPart.getTransientData().get("e4_override_icon_image_key");
        if (overriddenImage != null) {
            compPart.getTransientData().put("e4_override_icon_image_key", overriddenImage);
        }
        compPart.getTags().add("removeOnHide");
        return compPart;
    }

    void splitPart(MPart partToSplit, boolean horizontal) {
        MElementContainer parent = partToSplit.getParent();
        int index = parent.getChildren().indexOf(partToSplit);
        MPart editorClone = (MPart)this.ms.cloneElement((MUIElement)partToSplit, null);
        MCompositePart compPart = this.createCompositePart(partToSplit);
        compPart.getChildren().add(editorClone);
        compPart.setSelectedElement((MUIElement)editorClone);
        parent.getChildren().add(index, compPart);
        parent.setSelectedElement((MUIElement)compPart);
        int orientation = horizontal ? 0 : 2;
        this.ms.insert((MPartSashContainerElement)partToSplit, (MPartSashContainerElement)editorClone, orientation, 0.5f);
        this.ps.activate(partToSplit);
    }
}

