/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.ReviewsFileStorageException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUITextPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class NewAnomalyHandler
extends AbstractHandler {
    private static final String[] WARNING_BUTTONS_LABELS = new String[]{"Continue", "Cancel"};
    private static final String VERSION_STR = "Version: ";
    private static final String QUESTION_TITLE = "R4E question";
    private static final String WORKSPACE_FILE_STR = "Workspace file: ";
    private static final String FILE_VERSION_STR = "Selected file version to review: ";
    private static final String QUESTION_STR = "Are you sure you want to add this anomaly to the workspace file ?";
    private static final String MESSAGE_STR = "You are adding an anomaly to a file version which is different from the one selected for review.";
    private static final String COMMAND_MESSAGE = "Adding Anomaly...";

    public Object execute(final ExecutionEvent event) {
        final IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        final IEditorInput input = editorPart != null ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput() : null;
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = R4EUIConstants.R4E_UI_JOB_FAMILY;
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                R4EUIModelController.setJobInProgress(true);
                if (selection instanceof ITextSelection) {
                    monitor.beginTask(NewAnomalyHandler.COMMAND_MESSAGE, -1);
                    NewAnomalyHandler.this.addAnomalyFromText((ITextSelection)selection, input);
                } else if (selection instanceof ITreeSelection) {
                    if (editorPart != null && editorPart instanceof ITextEditor) {
                        ((ITextEditor)editorPart).getSelectionProvider().setSelection(null);
                    }
                    monitor.beginTask(NewAnomalyHandler.COMMAND_MESSAGE, ((IStructuredSelection)selection).size());
                    Iterator iterator = ((ITreeSelection)selection).iterator();
                    while (iterator.hasNext()) {
                        NewAnomalyHandler.this.addAnomalyFromTree(iterator.next(), monitor);
                        if (!monitor.isCanceled()) continue;
                        R4EUIModelController.setJobInProgress(false);
                        return Status.CANCEL_STATUS;
                    }
                } else if ((selection == null || selection.isEmpty()) && editorPart != null && editorPart instanceof ITextEditor) {
                    IRegion region = ((ITextEditor)editorPart).getHighlightRange();
                    final TextSelection selectedText = new TextSelection(((ITextEditor)editorPart).getDocumentProvider().getDocument((Object)editorPart.getEditorInput()), region.getOffset(), region.getLength());
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            ((ITextEditor)editorPart).getSelectionProvider().setSelection((ISelection)selectedText);
                        }
                    });
                    NewAnomalyHandler.this.addAnomalyFromText((ITextSelection)selectedText, input);
                }
                R4EUIModelController.setJobInProgress(false);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
        return null;
    }

    private void addAnomalyFromText(ITextSelection aSelection, IEditorInput aInput) {
        try {
            R4EUITextPosition position = CommandUtils.getPosition(aSelection);
            R4EFileVersion baseVersion = CommandUtils.getBaseFileData(aInput);
            R4EFileVersion targetVersion = CommandUtils.getTargetFileData(aInput);
            if (targetVersion != null) {
                this.addAnomaly(baseVersion, targetVersion, position);
            } else {
                R4EUIPlugin.Ftracer.traceWarning("Trying to add review item to base file");
                final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Add Anomaly Error", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "No Target File present to Add Anomaly", null), 4);
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        dialog.open();
                    }
                });
            }
        }
        catch (CoreException e) {
            UIUtils.displayCoreErrorDialog(e);
        }
        catch (ReviewsFileStorageException e) {
            UIUtils.displayReviewsFileStorageErrorDialog(e);
        }
    }

    private void addAnomalyFromTree(Object aSelection, IProgressMonitor aMonitor) {
        try {
            R4EUITextPosition position = null;
            IFile workspaceFile = null;
            if (aSelection instanceof IFile) {
                position = CommandUtils.getPosition((IFile)aSelection);
                workspaceFile = (IFile)aSelection;
            } else if (R4EUIPlugin.isJDTAvailable() && aSelection instanceof org.eclipse.jdt.core.ISourceReference) {
                workspaceFile = (IFile)((IJavaElement)aSelection).getResource();
                position = CommandUtils.getPosition((org.eclipse.jdt.core.ISourceReference)aSelection, workspaceFile);
            } else if (R4EUIPlugin.isCDTAvailable() && aSelection instanceof ISourceReference) {
                if (aSelection instanceof ITranslationUnit) {
                    workspaceFile = (IFile)((ICElement)aSelection).getResource();
                } else if (aSelection instanceof ICElement) {
                    workspaceFile = (IFile)((ICElement)aSelection).getParent().getResource();
                } else {
                    R4EUIPlugin.Ftracer.traceWarning("Invalid selection " + aSelection.getClass().toString() + ".  Ignoring");
                    return;
                }
                position = CommandUtils.getPosition((ISourceReference)aSelection, workspaceFile);
            } else {
                R4EUIPlugin.Ftracer.traceWarning("Invalid selection " + aSelection.getClass().toString() + ".  Ignoring");
                return;
            }
            R4EFileVersion baseVersion = CommandUtils.updateBaseFile(workspaceFile);
            R4EFileVersion targetVersion = CommandUtils.updateTargetFile(workspaceFile);
            if (targetVersion != null) {
                aMonitor.subTask("Adding " + targetVersion.getName());
                this.addAnomaly(baseVersion, targetVersion, position);
                aMonitor.worked(1);
            } else {
                R4EUIPlugin.Ftracer.traceWarning("Trying to add review item to base file");
                final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Add Anomaly Error", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "No Target File present to Add Anomaly", null), 4);
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        dialog.open();
                    }
                });
            }
        }
        catch (CoreException e) {
            UIUtils.displayCoreErrorDialog(e);
        }
        catch (ReviewsFileStorageException e) {
            UIUtils.displayReviewsFileStorageErrorDialog(e);
        }
    }

    private void addAnomaly(R4EFileVersion aBaseFileVersion, final R4EFileVersion aTargetFileVersion, IR4EUIPosition aUIPosition) {
        R4EUIFileContext tempFileContext = null;
        List<R4EUIReviewItem> reviewItems = R4EUIModelController.getActiveReview().getReviewItems();
        boolean isNewAnomaly = true;
        for (R4EUIReviewItem reviewItem : reviewItems) {
            R4EUIFileContext[] files;
            R4EUIFileContext[] r4EUIFileContextArray = files = (R4EUIFileContext[])reviewItem.getChildren();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                R4EUIFileContext file = r4EUIFileContextArray[n2];
                if (file.getFileContext().getTarget() != null && aTargetFileVersion.getLocalVersionID().equals(file.getFileContext().getTarget().getLocalVersionID())) {
                    R4EUIAnomalyBasic[] anomalies;
                    R4EUIAnomalyContainer anomalyContainer = file.getAnomalyContainerElement();
                    R4EUIAnomalyBasic[] r4EUIAnomalyBasicArray = anomalies = (R4EUIAnomalyBasic[])anomalyContainer.getChildren();
                    int n3 = anomalies.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        R4EUIAnomalyBasic uiAnomaly = r4EUIAnomalyBasicArray[n4];
                        if (uiAnomaly.getPosition().isSameAs(aUIPosition)) {
                            isNewAnomaly = false;
                            this.addCommentToExistingAnomaly(uiAnomaly);
                            R4EUIPlugin.Ftracer.traceInfo("Added comment to existing anomaly: Target = " + file.getFileContext().getTarget().getName() + (file.getFileContext().getBase() != null ? "Base = " + file.getFileContext().getBase().getName() : "") + " Position = " + aUIPosition.toString());
                        }
                        ++n4;
                    }
                    if (isNewAnomaly) {
                        this.addAnomalyToExistingFileContext(aTargetFileVersion, anomalyContainer, aUIPosition);
                        R4EUIPlugin.Ftracer.traceInfo("Added anomaly: Target = " + file.getFileContext().getTarget().getName() + (file.getFileContext().getBase() != null ? "Base = " + file.getFileContext().getBase().getName() : "") + " Position = " + aUIPosition.toString());
                    }
                    return;
                }
                if (file.getFileContext().getTarget() != null) {
                    String reviewPlatformURI = file.getFileContext().getTarget().getPlatformURI();
                    String targetPlatformURI = aTargetFileVersion.getPlatformURI();
                    if (reviewPlatformURI != null && targetPlatformURI != null && reviewPlatformURI.equals(targetPlatformURI)) {
                        tempFileContext = file;
                    }
                }
                ++n2;
            }
        }
        if (tempFileContext != null) {
            final int[] result = new int[1];
            final R4EUIFileContext dContext = tempFileContext;
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialog dialog = NewAnomalyHandler.this.displayDifferentFileVersionDialog(aTargetFileVersion, dContext);
                    result[0] = dialog.open();
                }
            });
            if (result[0] == 1) {
                return;
            }
        }
        this.addAnomalyToNewFileContext(aBaseFileVersion, aTargetFileVersion, aUIPosition);
        R4EUIPlugin.Ftracer.traceInfo("Added Anomaly: Target = " + aTargetFileVersion.getName() + "_" + aTargetFileVersion.getVersionID() + (aBaseFileVersion != null ? "Base = " + aBaseFileVersion.getName() + "_" + aBaseFileVersion.getVersionID() : "") + " Position = " + aUIPosition.toString());
    }

    private MessageDialog displayDifferentFileVersionDialog(R4EFileVersion aTargetFileVersion, R4EUIFileContext aTempFileContext) {
        String wsFileName = aTargetFileVersion.getRepositoryPath();
        String wsFileVersion = aTargetFileVersion.getVersionID();
        String riFileName = aTempFileContext.getTargetFileVersion().getRepositoryPath();
        String riFileVersion = aTempFileContext.getTargetFileVersion().getVersionID();
        StringBuilder sb = new StringBuilder();
        sb.append(MESSAGE_STR + R4EUIConstants.LINE_FEED + R4EUIConstants.LINE_FEED);
        sb.append(FILE_VERSION_STR);
        sb.append(String.valueOf(riFileName) + R4EUIConstants.LINE_FEED);
        sb.append(VERSION_STR);
        sb.append(String.valueOf(riFileVersion) + R4EUIConstants.LINE_FEED + R4EUIConstants.LINE_FEED);
        sb.append(WORKSPACE_FILE_STR);
        sb.append(String.valueOf(wsFileName) + R4EUIConstants.LINE_FEED);
        sb.append(VERSION_STR);
        sb.append(String.valueOf(wsFileVersion) + R4EUIConstants.LINE_FEED + R4EUIConstants.LINE_FEED);
        sb.append(QUESTION_STR);
        MessageDialog dialog = new MessageDialog(null, QUESTION_TITLE, null, sb.toString(), 4, WARNING_BUTTONS_LABELS, 0);
        return dialog;
    }

    private void addCommentToExistingAnomaly(R4EUIAnomalyBasic aUIAnomaly) {
        aUIAnomaly.createComment(false);
    }

    private void addAnomalyToExistingFileContext(R4EFileVersion aTargetFileVersion, R4EUIAnomalyContainer aContainer, IR4EUIPosition aUIPosition) {
        aContainer.createAnomaly(aTargetFileVersion, (R4EUITextPosition)aUIPosition);
    }

    private void addAnomalyToNewFileContext(final R4EFileVersion aBaseFileVersion, final R4EFileVersion aTargetFileVersion, final IR4EUIPosition aUIPosition) {
        final R4EAnomaly tempAnomaly = R4EUIAnomalyContainer.createDetachedAnomaly();
        if (tempAnomaly != null) {
            Job job = new Job("Creating New Anomaly..."){
                public String familyName;
                {
                    super($anonymous0);
                    this.familyName = R4EUIConstants.R4E_UI_JOB_FAMILY;
                }

                public boolean belongsTo(Object family) {
                    return this.familyName.equals(family);
                }

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        R4EUIReviewBasic uiReview = R4EUIModelController.getActiveReview();
                        R4EUIReviewItem uiReviewItem = uiReview.createResourceReviewItem(aTargetFileVersion.getName());
                        if (uiReviewItem == null) {
                            return Status.CANCEL_STATUS;
                        }
                        R4EUIFileContext uiFileContext = uiReviewItem.createFileContext(aBaseFileVersion, aTargetFileVersion, null);
                        if (uiFileContext == null) {
                            uiReview.removeChildren(uiReviewItem, false);
                            return Status.CANCEL_STATUS;
                        }
                        R4EUIAnomalyContainer uiAnomalyContainer = uiFileContext.getAnomalyContainerElement();
                        R4EUIAnomalyBasic uiAnomaly = uiAnomalyContainer.createAnomalyFromDetached(aTargetFileVersion, tempAnomaly, (R4EUITextPosition)aUIPosition);
                        R4EUIModelController.setJobInProgress(false);
                        UIUtils.setNavigatorViewFocus(uiAnomaly, -1);
                    }
                    catch (ResourceHandlingException e) {
                        UIUtils.displayResourceErrorDialog(e);
                    }
                    catch (OutOfSyncException e) {
                        UIUtils.displaySyncErrorDialog(e);
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }
}

