/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleClass;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleRank;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IAnomalyInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.ICalendarDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EInputValidator;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRule;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleArea;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleSet;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleViolation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorContentProvider;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorLabelProvider;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class AnomalyInputDialog
extends FormDialog
implements IAnomalyInputDialog {
    private static final String ADD_ANOMALY_DIALOG_TITLE = "Enter Anomaly Details";
    private static final String ADD_ANOMALY_DIALOG_VALUE = "Anomaly Title: ";
    private static final String ADD_DESCRIPTION_DIALOG_VALUE = "Anomaly Description: ";
    private static final String BASIC_PARAMS_HEADER_MSG = "Enter the mandatory basic parameters for this anomaly";
    private static final String EXTRA_PARAMS_HEADER_MSG = "Enter the optional extra parameters for this Review";
    private static final String ADD_RULE_DIALOG_VALUE = "Rule Tree (Take note that the Anomaly will be created with values taken from the selected Design Rule)";
    private static final int DEFAULT_ELEMENT_COLUMN_WIDTH = 150;
    private static final int DEFAULT_TREE_COLUMN_WIDTH = 100;
    private String fAnomalyTitleValue = "";
    protected Text fAnomalyTitleInputTextField = null;
    private String fAnomalyDescriptionValue = "";
    protected Text fAnomalyDescriptionInputTextField;
    private R4EDesignRuleClass fAnomalyClassValue = null;
    protected CCombo fAnomalyClass = null;
    private R4EDesignRuleRank fAnomalyRankValue = null;
    protected CCombo fAnomalyRank = null;
    protected Text fDateText = null;
    private Date fAnomalyDueDateValue = null;
    protected TreeViewer fRuleTreeViewer = null;
    private R4EUIRule fRuleReferenceValue = null;
    private final IInputValidator fValidator;
    protected CCombo fAssignedToCombo = null;
    private String fAssignedToParticipant = null;
    private final List<R4EUIRuleSet> fOpenRuleSets = new ArrayList<R4EUIRuleSet>();
    R4EUIRule fSelectedRule = null;

    public AnomalyInputDialog(Shell aParentShell) {
        super(aParentShell);
        this.setBlockOnOpen(false);
        this.fValidator = new R4EInputValidator();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            IStructuredSelection selection;
            String validateResult = this.validateEmptyInput(this.fAnomalyTitleInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "No input given for Anomaly Title", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            this.fAnomalyTitleValue = this.fAnomalyTitleInputTextField.getText().trim();
            validateResult = this.validateEmptyInput(this.fAnomalyDescriptionInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "No input given for Anomaly Comment", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            this.fAnomalyDescriptionValue = this.fAnomalyDescriptionInputTextField.getText().trim();
            this.fRuleReferenceValue = null;
            if (this.fRuleTreeViewer.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)this.fRuleTreeViewer.getSelection()) != null) {
                this.fRuleReferenceValue = (R4EUIRule)selection.getFirstElement();
            }
            this.fAnomalyRankValue = UIUtils.getRankFromString(this.fAnomalyRank.getText());
            this.fAnomalyClassValue = UIUtils.getClassFromString(this.fAnomalyClass.getText());
            this.fAssignedToParticipant = this.fAssignedToCombo.getText();
        } else {
            this.fAnomalyTitleValue = null;
            this.fAnomalyDescriptionValue = null;
            this.fRuleReferenceValue = null;
            this.fAnomalyRankValue = null;
            this.fAnomalyClassValue = null;
            this.fAnomalyDueDateValue = null;
            this.fAssignedToParticipant = null;
        }
        for (R4EUIRuleSet ruleset : this.fOpenRuleSets) {
            ruleset.close();
        }
        R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
        this.fOpenRuleSets.clear();
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ADD_ANOMALY_DIALOG_TITLE);
        shell.setMinimumSize(400, 300);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm sform = mform.getForm();
        sform.setExpandVertical(true);
        Composite composite = sform.getBody();
        GridLayout layout = new GridLayout(4, false);
        composite.setLayout((Layout)layout);
        GridData textGridData = null;
        Section basicSection = toolkit.createSection(composite, 450);
        GridData basicSectionGridData = new GridData(4, 4, true, false);
        basicSectionGridData.horizontalSpan = 4;
        basicSection.setLayoutData((Object)basicSectionGridData);
        basicSection.setText("Basic Parameters");
        basicSection.setDescription(BASIC_PARAMS_HEADER_MSG);
        basicSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                AnomalyInputDialog.this.getShell().setSize(AnomalyInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite basicSectionClient = toolkit.createComposite((Composite)basicSection);
        basicSectionClient.setLayout((Layout)layout);
        basicSection.setClient((Control)basicSectionClient);
        Label label = toolkit.createLabel(basicSectionClient, ADD_ANOMALY_DIALOG_VALUE);
        label.setToolTipText("A Title that Identifies this Anomaly");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fAnomalyTitleInputTextField = toolkit.createText(basicSectionClient, "", 2052);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fAnomalyTitleInputTextField.setToolTipText("A Title that Identifies this Anomaly");
        this.fAnomalyTitleInputTextField.setLayoutData((Object)textGridData);
        this.fAnomalyTitleInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AnomalyInputDialog.this.fAnomalyTitleInputTextField.getText().length() > 0 && AnomalyInputDialog.this.fAnomalyDescriptionInputTextField.getText().length() > 0) {
                    AnomalyInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    AnomalyInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        label = toolkit.createLabel(basicSectionClient, ADD_DESCRIPTION_DIALOG_VALUE);
        label.setToolTipText("A Detailed Description of the Anomaly");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fAnomalyDescriptionInputTextField = toolkit.createText(basicSectionClient, "", 2562);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        textGridData.heightHint = this.fAnomalyTitleInputTextField.getLineHeight() * 7;
        this.fAnomalyDescriptionInputTextField.setToolTipText("A Detailed Description of the Anomaly");
        this.fAnomalyDescriptionInputTextField.setLayoutData((Object)textGridData);
        this.fAnomalyDescriptionInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AnomalyInputDialog.this.fAnomalyTitleInputTextField.getText().length() > 0 && AnomalyInputDialog.this.fAnomalyDescriptionInputTextField.getText().length() > 0) {
                    AnomalyInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    AnomalyInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        Section extraSection = toolkit.createSection(composite, 386);
        GridData extraSectionGridData = new GridData(4, 4, true, true);
        extraSectionGridData.horizontalSpan = 4;
        extraSection.setLayoutData((Object)extraSectionGridData);
        extraSection.setText("Extra Parameters");
        extraSection.setDescription(EXTRA_PARAMS_HEADER_MSG);
        extraSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                AnomalyInputDialog.this.getShell().setSize(AnomalyInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite extraSectionClient = toolkit.createComposite((Composite)extraSection);
        extraSectionClient.setLayout((Layout)layout);
        extraSection.setClient((Control)extraSectionClient);
        label = toolkit.createLabel(extraSectionClient, "Class: ");
        label.setToolTipText("The Class of this Anomaly");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fAnomalyClass = new CCombo(extraSectionClient, 2056);
        this.fAnomalyClass.setItems(UIUtils.getClasses());
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fAnomalyClass.setToolTipText("The Class of this Anomaly");
        this.fAnomalyClass.setLayoutData((Object)textGridData);
        label = toolkit.createLabel(extraSectionClient, "Rank: ");
        label.setToolTipText("The Rank (or Severity) of this Anomaly");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fAnomalyRank = new CCombo(extraSectionClient, 2056);
        this.fAnomalyRank.setItems(UIUtils.getRanks());
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fAnomalyRank.setToolTipText("The Class of this Anomaly");
        this.fAnomalyRank.setLayoutData((Object)textGridData);
        label = toolkit.createLabel(extraSectionClient, "Assigned to: ");
        textGridData = new GridData(4, 4, false, false);
        textGridData.horizontalSpan = 1;
        label.setLayoutData((Object)textGridData);
        this.fAssignedToCombo = new CCombo(extraSectionClient, 2056);
        String[] participants = R4EUIModelController.getActiveReview().getParticipantIDs().toArray(new String[R4EUIModelController.getActiveReview().getParticipantIDs().size()]);
        this.fAssignedToCombo.removeAll();
        this.fAssignedToCombo.add("");
        String[] stringArray = participants;
        int n = participants.length;
        int n2 = 0;
        while (n2 < n) {
            String participant = stringArray[n2];
            this.fAssignedToCombo.add(participant);
            ++n2;
        }
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fAssignedToCombo.setToolTipText("Participant assigned to Review this element.");
        this.fAssignedToCombo.setLayoutData((Object)textGridData);
        label = toolkit.createLabel(extraSectionClient, "Due Date: ");
        textGridData = new GridData(4, 4, false, false);
        textGridData.horizontalSpan = 1;
        label.setLayoutData((Object)textGridData);
        Composite dateComposite = toolkit.createComposite(extraSectionClient);
        textGridData = new GridData(4, 4, true, true);
        textGridData.horizontalSpan = 3;
        dateComposite.setToolTipText("The Target Date to Address this Anomaly");
        dateComposite.setLayoutData((Object)textGridData);
        dateComposite.setLayout((Layout)new GridLayout(2, false));
        this.fDateText = toolkit.createText(dateComposite, "", 2056);
        this.fDateText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fDateText.setEditable(false);
        Button calendarButton = toolkit.createButton(dateComposite, "...", 0);
        calendarButton.setLayoutData((Object)new GridData(4, 4, false, false));
        calendarButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ICalendarDialog dialog = R4EUIDialogFactory.getInstance().getCalendarDialog();
                int result = dialog.open();
                if (result == 0) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd");
                    AnomalyInputDialog.this.fDateText.setText(dateFormat.format(dialog.getDate()));
                    AnomalyInputDialog.this.fAnomalyDueDateValue = dialog.getDate();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = toolkit.createLabel(extraSectionClient, ADD_RULE_DIALOG_VALUE);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 4;
        label.setLayoutData((Object)textGridData);
        this.fRuleTreeViewer = new TreeViewer(extraSectionClient, 68360);
        this.fRuleTreeViewer.setContentProvider((IContentProvider)new ReviewNavigatorContentProvider());
        this.fRuleTreeViewer.getTree().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fRuleTreeViewer, (int)2);
        TreeViewerColumn elementColumn = new TreeViewerColumn(this.fRuleTreeViewer, 0);
        elementColumn.getColumn().setText("Rule Tree");
        elementColumn.getColumn().setWidth(150);
        elementColumn.setLabelProvider((CellLabelProvider)new ReviewNavigatorLabelProvider(){

            public String getToolTipText(Object element) {
                if (element instanceof R4EUIRule) {
                    return ((R4EUIRule)element).getRule().getDescription();
                }
                return null;
            }

            public void update(ViewerCell cell) {
                IR4EUIModelElement element = (IR4EUIModelElement)cell.getElement();
                if (element instanceof R4EUIRuleSet && !element.isOpen()) {
                    cell.setForeground(AnomalyInputDialog.this.getShell().getDisplay().getSystemColor(3));
                } else {
                    cell.setForeground(AnomalyInputDialog.this.getShell().getDisplay().getSystemColor(2));
                }
                cell.setText(element.getName());
                cell.setImage(element.getImage());
            }
        });
        TreeViewerColumn titleColumn = new TreeViewerColumn(this.fRuleTreeViewer, 0);
        titleColumn.getColumn().setText("Title: ");
        titleColumn.getColumn().setWidth(100);
        titleColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof R4EUIRule) {
                    return ((R4EUIRule)element).getRule().getTitle();
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof R4EUIRule) {
                    return ((R4EUIRule)element).getRule().getDescription();
                }
                return null;
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 250;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 10000;
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof R4EUIRule) {
                    cell.setText(((R4EUIRule)element).getRule().getTitle());
                } else {
                    cell.setText(null);
                }
            }
        });
        TreeViewerColumn classColumn = new TreeViewerColumn(this.fRuleTreeViewer, 0);
        classColumn.getColumn().setText("Class: ");
        classColumn.getColumn().setWidth(100);
        classColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof R4EUIRule) {
                    return AnomalyInputDialog.this.getClassStr(((R4EUIRule)element).getRule().getClass_());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof R4EUIRule) {
                    return ((R4EUIRule)element).getRule().getDescription();
                }
                return null;
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 250;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 10000;
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof R4EUIRule) {
                    cell.setText(AnomalyInputDialog.this.getClassStr(((R4EUIRule)element).getRule().getClass_()));
                } else {
                    cell.setText(null);
                }
            }
        });
        TreeViewerColumn rankColumn = new TreeViewerColumn(this.fRuleTreeViewer, 0);
        rankColumn.getColumn().setText("Rank: ");
        rankColumn.getColumn().setWidth(100);
        rankColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof R4EUIRule) {
                    return AnomalyInputDialog.this.getRankStr(((R4EUIRule)element).getRule().getRank());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof R4EUIRule) {
                    return ((R4EUIRule)element).getRule().getDescription();
                }
                return null;
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 250;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 10000;
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof R4EUIRule) {
                    cell.setText(AnomalyInputDialog.this.getRankStr(((R4EUIRule)element).getRule().getRank()));
                } else {
                    cell.setText(null);
                }
            }
        });
        this.fRuleTreeViewer.setInput((Object)R4EUIModelController.getRootElement());
        this.fRuleTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof R4EUIRuleSet || element instanceof R4EUIRuleArea || element instanceof R4EUIRuleViolation || element instanceof R4EUIRule) {
                    IR4EUIModelElement parentRuleSetElement = (IR4EUIModelElement)element;
                    while (!(parentRuleSetElement instanceof R4EUIRuleSet) && parentRuleSetElement.getParent() != null) {
                        if (!parentRuleSetElement.isEnabled()) {
                            return false;
                        }
                        parentRuleSetElement = parentRuleSetElement.getParent();
                    }
                    if (((R4EUIReviewGroup)R4EUIModelController.getActiveReview().getParent()).getRuleSets().contains(parentRuleSetElement)) {
                        if (!parentRuleSetElement.isOpen()) {
                            try {
                                ((R4EUIRuleSet)parentRuleSetElement).openReadOnly();
                                AnomalyInputDialog.this.fOpenRuleSets.add((R4EUIRuleSet)parentRuleSetElement);
                            }
                            catch (ResourceHandlingException e) {
                                R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                                R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                            }
                            catch (CompatibilityException e) {
                                R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                                R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                            }
                        }
                        return true;
                    }
                }
                return false;
            }
        });
        this.fRuleTreeViewer.expandAll();
        this.fRuleTreeViewer.refresh();
        textGridData = new GridData(4, 4, true, true);
        textGridData.horizontalSpan = 4;
        this.fRuleTreeViewer.getTree().setLayoutData((Object)textGridData);
        this.fRuleTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    R4EUIRule rule;
                    if (((IStructuredSelection)event.getSelection()).getFirstElement() == null) {
                        return;
                    }
                    if (((IStructuredSelection)event.getSelection()).getFirstElement() instanceof R4EUIRule && !(rule = (R4EUIRule)((IStructuredSelection)event.getSelection()).getFirstElement()).equals(AnomalyInputDialog.this.fSelectedRule)) {
                        AnomalyInputDialog.this.fAnomalyTitleInputTextField.setText(rule.getRule().getTitle());
                        AnomalyInputDialog.this.fAnomalyDescriptionInputTextField.setText(rule.getRule().getDescription());
                        AnomalyInputDialog.this.fAnomalyClass.select(rule.getRule().getClass_().getValue());
                        AnomalyInputDialog.this.fAnomalyRank.select(rule.getRule().getRank().getValue());
                        AnomalyInputDialog.this.fAnomalyClass.setEnabled(false);
                        AnomalyInputDialog.this.fAnomalyRank.setEnabled(false);
                        AnomalyInputDialog.this.fAnomalyTitleInputTextField.setEnabled(false);
                        AnomalyInputDialog.this.fSelectedRule = rule;
                        return;
                    }
                }
                AnomalyInputDialog.this.fRuleTreeViewer.setSelection(null);
                AnomalyInputDialog.this.fAnomalyClass.setEnabled(true);
                AnomalyInputDialog.this.fAnomalyRank.setEnabled(true);
                AnomalyInputDialog.this.fAnomalyTitleInputTextField.setEnabled(true);
                AnomalyInputDialog.this.fSelectedRule = null;
            }
        });
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    protected boolean isResizable() {
        return true;
    }

    public String getAnomalyTitleValue() {
        return this.fAnomalyTitleValue;
    }

    public String getAnomalyDescriptionValue() {
        return this.fAnomalyDescriptionValue;
    }

    public R4EUIRule getRuleReferenceValue() {
        return this.fRuleReferenceValue;
    }

    private String validateEmptyInput(Text aText) {
        return this.fValidator.isValid(aText.getText());
    }

    protected void setShellStyle(int newShellStyle) {
        int newstyle = newShellStyle & 0xFFFEFFFF;
        super.setShellStyle(newstyle |= 0);
    }

    public int open() {
        super.open();
        this.pumpMessages();
        return super.getReturnCode();
    }

    protected void pumpMessages() {
        Shell sh = this.getShell();
        Display disp = sh.getDisplay();
        while (!sh.isDisposed()) {
            if (disp.readAndDispatch()) continue;
            disp.sleep();
        }
        disp.update();
    }

    protected String getClassStr(R4EDesignRuleClass aClass) {
        if (aClass.equals((Object)R4EDesignRuleClass.R4E_CLASS_ERRONEOUS)) {
            return "Erroneous";
        }
        if (aClass.equals((Object)R4EDesignRuleClass.R4E_CLASS_SUPERFLUOUS)) {
            return "Superfluous";
        }
        if (aClass.equals((Object)R4EDesignRuleClass.R4E_CLASS_IMPROVEMENT)) {
            return "Improvement";
        }
        if (aClass.equals((Object)R4EDesignRuleClass.R4E_CLASS_QUESTION)) {
            return "Question";
        }
        return null;
    }

    public void setClass_(R4EDesignRuleClass aClass) {
        this.fAnomalyClassValue = aClass;
        if (this.fAnomalyClassValue != null) {
            this.fAnomalyClass.setText(this.getClassStr(this.fAnomalyClassValue));
        }
    }

    public R4EDesignRuleClass getClass_() {
        return this.fAnomalyClassValue;
    }

    protected String getRankStr(R4EDesignRuleRank aRank) {
        if (aRank.equals((Object)R4EDesignRuleRank.R4E_RANK_NONE)) {
            return "NONE";
        }
        if (aRank.equals((Object)R4EDesignRuleRank.R4E_RANK_MINOR)) {
            return "MINOR";
        }
        if (aRank.equals((Object)R4EDesignRuleRank.R4E_RANK_MAJOR)) {
            return "MAJOR";
        }
        if (aRank.equals((Object)R4EDesignRuleRank.R4E_RANK_DEPRECATED)) {
            return "MINOR";
        }
        return null;
    }

    public void setRank(R4EDesignRuleRank aRank) {
        this.fAnomalyRankValue = aRank;
        if (this.fAnomalyRankValue != null) {
            this.fAnomalyRank.setText(this.getRankStr(this.fAnomalyRankValue));
        }
    }

    public R4EDesignRuleRank getRank() {
        return this.fAnomalyRankValue;
    }

    public void setDueDate(Date aDate) {
        this.fAnomalyDueDateValue = aDate;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd");
        if (this.fAnomalyDueDateValue != null) {
            this.fDateText.setText(dateFormat.format(this.fAnomalyDueDateValue));
        }
    }

    public Date getDueDate() {
        return this.fAnomalyDueDateValue;
    }

    public void setTitle(String aTitle) {
        this.fAnomalyTitleInputTextField.setText(aTitle);
    }

    public void setDescription(String aDescription) {
        this.fAnomalyDescriptionInputTextField.setText(aDescription);
    }

    public void setRuleID(String aId) {
        List<R4EUIRuleSet> ruleSets = R4EUIModelController.getRootElement().getRuleSets();
        for (R4EUIRuleSet ruleSet : ruleSets) {
            IR4EUIModelElement[] iR4EUIModelElementArray = ruleSet.getChildren();
            int n = iR4EUIModelElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IR4EUIModelElement area = iR4EUIModelElementArray[n2];
                IR4EUIModelElement[] iR4EUIModelElementArray2 = area.getChildren();
                int n3 = iR4EUIModelElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IR4EUIModelElement violation = iR4EUIModelElementArray2[n4];
                    IR4EUIModelElement[] iR4EUIModelElementArray3 = violation.getChildren();
                    int n5 = iR4EUIModelElementArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IR4EUIModelElement rule = iR4EUIModelElementArray3[n6];
                        if (((R4EUIRule)rule).getRule().getId().equals(aId)) {
                            this.fRuleTreeViewer.setSelection((ISelection)new StructuredSelection((Object)rule), true);
                            return;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public String getAssigned() {
        return this.fAssignedToParticipant;
    }

    public void setAssigned(String aParticipant) {
        this.fAssignedToCombo.setText(aParticipant);
    }
}

