/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.naming.NamingException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.frame.core.model.Topic;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUserRole;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.ParticipantProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.mylyn.reviews.userSearch.query.IQueryUser;
import org.eclipse.mylyn.reviews.userSearch.query.QueryUserFactory;
import org.eclipse.mylyn.reviews.userSearch.userInfo.IUserInfo;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIParticipant
extends R4EUIModelElement {
    public static final String PARTICIPANT_ICON_FILE = "icons/obj16/part_obj.png";
    public static final String PARTICIPANT_REVIEWER_ICON_FILE = "icons/obj16/partrevr_obj.png";
    public static final String PARTICIPANT_LEAD_ICON_FILE = "icons/obj16/partlead_obj.png";
    public static final String PARTICIPANT_AUTHOR_ICON_FILE = "icons/obj16/partauthr_obj.png";
    public static final String PARTICIPANT_ORGANIZER_ICON_FILE = "icons/obj16/partorg_obj.png";
    private static final String REMOVE_ELEMENT_COMMAND_NAME = "Disable Participant";
    private static final String REMOVE_ELEMENT_COMMAND_TOOLTIP = "Disable (and Optionally Remove) this Participant";
    private static final String RESTORE_ELEMENT_COMMAND_NAME = "Restore Participant";
    private static final String RESTORE_ELEMENT_COMMAND_TOOLTIP = "Restore this disabled Participant";
    private final R4EParticipant fParticipant;
    private String fParticipantDetails = null;

    public R4EUIParticipant(IR4EUIModelElement aParent, R4EParticipant aParticipant, R4EReviewType aType) {
        super(aParent, aParticipant.getId());
        this.fReadOnly = aParent.isReadOnly();
        this.fParticipant = aParticipant;
        this.setRoleIcon(aType);
    }

    @Override
    public String getToolTip() {
        return this.fParticipant.getEmail();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new ParticipantProperties(this);
        }
        return null;
    }

    public R4EParticipant getParticipant() {
        return this.fParticipant;
    }

    public void setRoleIcon(R4EReviewType aType) {
        if (aType.equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC)) {
            this.setImage(PARTICIPANT_ICON_FILE);
        } else {
            EList roles = this.fParticipant.getRoles();
            for (R4EUserRole role : roles) {
                if (!role.equals((Object)R4EUserRole.R4E_ROLE_LEAD)) continue;
                this.setImage(PARTICIPANT_LEAD_ICON_FILE);
                return;
            }
            for (R4EUserRole role : roles) {
                if (!role.equals((Object)R4EUserRole.R4E_ROLE_ORGANIZER)) continue;
                this.setImage(PARTICIPANT_ORGANIZER_ICON_FILE);
                return;
            }
            for (R4EUserRole role : roles) {
                if (!role.equals((Object)R4EUserRole.R4E_ROLE_AUTHOR)) continue;
                this.setImage(PARTICIPANT_AUTHOR_ICON_FILE);
                return;
            }
            for (R4EUserRole role : roles) {
                if (!role.equals((Object)R4EUserRole.R4E_ROLE_REVIEWER)) continue;
                this.setImage(PARTICIPANT_REVIEWER_ICON_FILE);
                return;
            }
            this.setImage(PARTICIPANT_ICON_FILE);
        }
    }

    public String[] getRoles(EList<R4EUserRole> aRoles) {
        ArrayList<String> roles = new ArrayList<String>();
        for (R4EUserRole role : aRoles) {
            if (role.getValue() == 3) {
                roles.add("Organizer");
                continue;
            }
            if (role.getValue() == 1) {
                roles.add("Lead");
                continue;
            }
            if (role.getValue() == 2) {
                roles.add("Author");
                continue;
            }
            if (role.getValue() != 0) continue;
            roles.add("Reviewer");
        }
        return roles.toArray(new String[roles.size()]);
    }

    public static R4EUserRole mapStringToRole(String aRoleStr) {
        if (aRoleStr.equals("Organizer")) {
            return R4EUserRole.R4E_ROLE_ORGANIZER;
        }
        if (aRoleStr.equals("Lead")) {
            return R4EUserRole.R4E_ROLE_LEAD;
        }
        if (aRoleStr.equals("Author")) {
            return R4EUserRole.R4E_ROLE_AUTHOR;
        }
        if (aRoleStr.equals("Reviewer")) {
            return R4EUserRole.R4E_ROLE_REVIEWER;
        }
        return null;
    }

    public static String mapRoleToString(R4EUserRole aRole) {
        if (aRole.equals((Object)R4EUserRole.R4E_ROLE_ORGANIZER)) {
            return "Organizer";
        }
        if (aRole.equals((Object)R4EUserRole.R4E_ROLE_LEAD)) {
            return "Lead";
        }
        if (aRole.equals((Object)R4EUserRole.R4E_ROLE_AUTHOR)) {
            return "Author";
        }
        if (aRole.equals((Object)R4EUserRole.R4E_ROLE_REVIEWER)) {
            return "Reviewer";
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.fParticipant.isEnabled();
    }

    @Override
    public void setEnabled(boolean aEnabled) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fParticipant, R4EUIModelController.getReviewer());
        this.fParticipant.setEnabled(true);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    @Override
    public void setModelData(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fParticipant, R4EUIModelController.getReviewer());
        this.fParticipant.setId(((R4EParticipant)aModelComponent).getId());
        this.fParticipant.setEmail(((R4EParticipant)aModelComponent).getEmail());
        this.fParticipant.getRoles().addAll((Collection)((R4EParticipant)aModelComponent).getRoles());
        this.fParticipant.setFocusArea(((R4EParticipant)aModelComponent).getFocusArea());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    public String getParticipantDetails() {
        return this.fParticipantDetails;
    }

    public void setParticipantDetails() {
        if (R4EUIModelController.isUserQueryAvailable()) {
            try {
                IQueryUser query = new QueryUserFactory().getInstance();
                ArrayList info = query.searchByUserId(this.fParticipant.getId());
                if (info.size() > 0) {
                    IUserInfo userInfo = (IUserInfo)info.get(0);
                    this.fParticipantDetails = UIUtils.buildUserDetailsString(userInfo);
                    if (this.fParticipant.getEmail() == null) {
                        this.fParticipant.setEmail(userInfo.getEmail());
                    }
                }
            }
            catch (NamingException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            }
            catch (IOException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            }
        }
    }

    @Override
    public boolean isRemoveElementCmd() {
        return this.isEnabled() && !this.isAssigned(this.fParticipant.getId(), true) && !this.isAnomalyCreator() && !this.isReadOnly() && !this.fParticipant.getRoles().contains((Object)R4EUserRole.R4E_ROLE_ORGANIZER) && !this.fParticipant.getRoles().contains((Object)R4EUserRole.R4E_ROLE_LEAD) && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public boolean isAssigned(String aUsername, boolean aCheckChildren) {
        return ((R4EUIReviewBasic)this.getParent().getParent()).isAssigned(aUsername, aCheckChildren);
    }

    private boolean isAnomalyCreator() {
        EList anomalies = ((R4EUIReviewBasic)this.getParent().getParent()).getReview().getTopics();
        for (Topic anomaly : anomalies) {
            if (!anomaly.getUser().equals(this.fParticipant)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getRemoveElementCmdName() {
        return REMOVE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRemoveElementCmdTooltip() {
        return REMOVE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isRestoreElementCmd() {
        if (!this.getParent().getParent().isEnabled()) {
            return false;
        }
        return !this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public String getRestoreElementCmdName() {
        return RESTORE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRestoreElementCmdTooltip() {
        return RESTORE_ELEMENT_COMMAND_TOOLTIP;
    }
}

