/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.filters;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.filters.AnomaliesMyFilter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorActionGroup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.progress.UIJob;

public class AnomaliesMyFilterHandler
extends AbstractHandler
implements IElementUpdater {
    private static final String COMMAND_MESSAGE = "Applying My Anomalies Filter...";

    public Object execute(final ExecutionEvent aEvent) {
        UIJob job = new UIJob(COMMAND_MESSAGE){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean oldValue;
                monitor.beginTask(AnomaliesMyFilterHandler.COMMAND_MESSAGE, 1);
                TreeViewer viewer = R4EUIModelController.getNavigatorView().getTreeViewer();
                Object[] elements = viewer.getExpandedElements();
                AnomaliesMyFilter filter = ((ReviewNavigatorActionGroup)R4EUIModelController.getNavigatorView().getActionSet()).getCurrentReviewFilter();
                try {
                    oldValue = HandlerUtil.toggleCommandState((Command)aEvent.getCommand());
                }
                catch (ExecutionException executionException) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                if (!oldValue) {
                    R4EUIPlugin.Ftracer.traceInfo("Apply My Anomalies filter to ReviewNavigator");
                    viewer.addFilter((ViewerFilter)filter);
                } else {
                    R4EUIPlugin.Ftracer.traceInfo("Remove My Anomalies filter from ReviewNavigator");
                    viewer.removeFilter((ViewerFilter)filter);
                }
                R4EUIModelController.getNavigatorView().getTreeViewer().setExpandedElements(elements);
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.mylyn.reviews.r4e.ui.commands.filters.AnomaliesMy");
        element.setChecked(((Boolean)command.getState("org.eclipse.ui.commands.toggleState").getValue()).booleanValue());
    }
}

