/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedAnomaly;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;

public class PreviousStateHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Regressing element to its Previous State...";

    public Object execute(ExecutionEvent aEvent) {
        final List<IR4EUIModelElement> selectedElements = UIUtils.getCommandUIElements();
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = "R4EUI";
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                if (!selectedElements.isEmpty()) {
                    R4EUIModelController.setJobInProgress(true);
                    monitor.beginTask(PreviousStateHandler.COMMAND_MESSAGE, selectedElements.size());
                    for (IR4EUIModelElement element : selectedElements) {
                        R4EAnomalyState newState;
                        R4EReviewPhase newPhase;
                        R4EUIPlugin.Ftracer.traceInfo("Regressing State for element " + element.getName());
                        if (element instanceof R4EUIReviewExtended) {
                            newPhase = ((R4EUIReviewExtended)element).getPreviousPhase();
                            UIUtils.changeReviewPhase(element, newPhase);
                        } else if (element instanceof R4EUIReviewBasic) {
                            newPhase = ((R4EUIReviewBasic)element).getPhaseFromString("STARTED");
                            UIUtils.changeReviewPhase(element, newPhase);
                        } else if (element instanceof R4EUIPostponedAnomaly) {
                            try {
                                if (((R4EUIPostponedAnomaly)element).checkOrigReviewCompatibility()) {
                                    newState = ((R4EUIPostponedAnomaly)element).getPreviousState();
                                    UIUtils.changeAnomalyState(element, newState);
                                }
                            }
                            catch (ResourceHandlingException e) {
                                UIUtils.displayResourceErrorDialog(e);
                            }
                            catch (CompatibilityException e) {
                                UIUtils.displayCompatibilityErrorDialog(e);
                            }
                        } else if (element instanceof R4EUIAnomalyExtended) {
                            newState = ((R4EUIAnomalyExtended)element).getPreviousState();
                            UIUtils.changeAnomalyState(element, newState);
                        }
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        R4EUIModelController.setJobInProgress(false);
                        UIUtils.setNavigatorViewFocus(element, 0);
                        return Status.CANCEL_STATUS;
                    }
                    R4EUIModelController.setJobInProgress(false);
                    UIUtils.setNavigatorViewFocus((IR4EUIModelElement)selectedElements.get(0), 0);
                }
                R4EUIModelController.setJobInProgress(false);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

