/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IReviewGroupInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EInputValidator;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleSet;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.EditableListWidget;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ReviewGroupInputDialog
extends FormDialog
implements IReviewGroupInputDialog {
    private static final String ADD_REVIEW_GROUP_DIALOG_TITLE = "Enter Review Group Details";
    private static final String ADD_REVIEW_GROUP_NAME_DIALOG_VALUE = "Group Name: ";
    private static final String ADD_REVIEW_GROUP_FOLDER_DIALOG_VALUE = "Group Folder: ";
    private static final String ADD_REVIEW_GROUP_DESCRIPTION_DIALOG_VALUE = "Group Description: ";
    private static final String ADD_REVIEW_GROUP_AVAILABLE_PROJECTS_DIALOG_VALUE = "Default Projects: ";
    private static final String ADD_REVIEW_GROUP_AVAILABLE_COMPONENTS_DIALOG_VALUE = "Default Components: ";
    private static final String ADD_REVIEW_GROUP_ENTRY_CRITERIA_DIALOG_VALUE = "Default Entry Criteria: ";
    private static final String ADD_RULE_SETS_DIALOG_VALUE = "Rule Sets: ";
    private static final String BASIC_PARAMS_HEADER_MSG = "Enter the mandatory basic parameters for this Review Group";
    private static final String EXTRA_PARAMS_HEADER_MSG = "Enter the optional extra parameters for this Review Group";
    private String fGroupNameValue = "";
    private Text fGroupNameInputTextField;
    private String fGroupFolderValue = "";
    private Text fGroupFolderInputTextField = null;
    private String fGroupDescriptionValue = "";
    private Text fGroupDescriptionInputTextField = null;
    private String[] fAvailableProjectsValues = null;
    private EditableListWidget fAvailableProjects = null;
    private String[] fAvailableComponentsValues = null;
    private EditableListWidget fAvailableComponents = null;
    private String fDefaultEntryCriteriaValue = "";
    private Text fDefaultEntryCriteriaTextField = null;
    private EditableListWidget fRuleSets = null;
    private String[] fRuleSetsValues = null;
    private final IInputValidator fValidator;

    public ReviewGroupInputDialog(Shell aParentShell) {
        super(aParentShell);
        this.setBlockOnOpen(true);
        this.fValidator = new R4EInputValidator();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String validateResult = this.validateEmptyInput(this.fGroupNameInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "No input given for Group Name", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            this.fGroupNameValue = this.fGroupNameInputTextField.getText().trim();
            validateResult = this.validateFolderInput(this.fGroupFolderInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Invalid input folder", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            validateResult = this.validateGroupExists(this.fGroupFolderInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Invalid input folder", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            this.fGroupFolderValue = this.fGroupFolderInputTextField.getText().trim();
            ArrayList<String> projectsValues = new ArrayList<String>();
            Item[] itemArray = this.fAvailableProjects.getItems();
            int n = itemArray.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                validateResult = this.validateEmptyInput(item.getText());
                if (validateResult == null) {
                    projectsValues.add(item.getText());
                }
                ++n2;
            }
            this.fAvailableProjectsValues = projectsValues.toArray(new String[projectsValues.size()]);
            ArrayList<String> componentsValues = new ArrayList<String>();
            Item[] itemArray2 = this.fAvailableComponents.getItems();
            int n3 = itemArray2.length;
            n = 0;
            while (n < n3) {
                Item item = itemArray2[n];
                validateResult = this.validateEmptyInput(item.getText());
                if (validateResult == null) {
                    componentsValues.add(item.getText());
                }
                ++n;
            }
            this.fAvailableComponentsValues = componentsValues.toArray(new String[componentsValues.size()]);
            validateResult = this.validateEmptyInput(this.fDefaultEntryCriteriaTextField);
            if (validateResult == null) {
                this.fDefaultEntryCriteriaValue = this.fDefaultEntryCriteriaTextField.getText();
            }
            ArrayList<String> ruleSetLocationsValues = new ArrayList<String>();
            Item[] itemArray3 = this.fRuleSets.getItems();
            int n4 = itemArray3.length;
            n3 = 0;
            while (n3 < n4) {
                Item item = itemArray3[n3];
                validateResult = this.validateEmptyInput(item.getText());
                if (validateResult == null) {
                    ruleSetLocationsValues.add(item.getText());
                }
                ++n3;
            }
            this.fRuleSetsValues = ruleSetLocationsValues.toArray(new String[ruleSetLocationsValues.size()]);
            this.fGroupDescriptionValue = this.fGroupDescriptionInputTextField.getText().trim();
        } else {
            this.fGroupNameValue = "";
            this.fGroupFolderValue = "";
            this.fGroupDescriptionValue = "";
            this.fDefaultEntryCriteriaValue = "";
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ADD_REVIEW_GROUP_DIALOG_TITLE);
        shell.setMinimumSize(400, 300);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm sform = mform.getForm();
        Composite composite = sform.getBody();
        composite.setLayout((Layout)new GridLayout());
        GridData textGridData = null;
        Section basicSection = toolkit.createSection(composite, 450);
        basicSection.setLayout((Layout)new GridLayout());
        basicSection.setLayoutData((Object)new GridData(4, 4, true, true));
        basicSection.setText("Basic Parameters");
        basicSection.setDescription(BASIC_PARAMS_HEADER_MSG);
        basicSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ReviewGroupInputDialog.this.getShell().setSize(ReviewGroupInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite basicSectionClient = toolkit.createComposite((Composite)basicSection);
        basicSectionClient.setLayout((Layout)new GridLayout(4, false));
        basicSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        basicSection.setClient((Control)basicSectionClient);
        Label label = toolkit.createLabel(basicSectionClient, ADD_REVIEW_GROUP_NAME_DIALOG_VALUE);
        label.setToolTipText("The Name that Identifies the Review Group");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fGroupNameInputTextField = toolkit.createText(basicSectionClient, "", 2052);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fGroupNameInputTextField.setToolTipText("The Name that Identifies the Review Group");
        this.fGroupNameInputTextField.setLayoutData((Object)textGridData);
        this.fGroupNameInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ReviewGroupInputDialog.this.fGroupNameInputTextField.getText().length() > 0 && ReviewGroupInputDialog.this.fGroupFolderInputTextField.getText().length() > 0 && ReviewGroupInputDialog.this.fGroupDescriptionInputTextField.getText().length() > 0) {
                    ReviewGroupInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    ReviewGroupInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        label = toolkit.createLabel(basicSectionClient, ADD_REVIEW_GROUP_FOLDER_DIALOG_VALUE);
        label.setToolTipText("The Location (Folder) where the Review Group Information is Stored.  Review Group Information is stored in files that have a _group_root.xrer suffix");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fGroupFolderInputTextField = toolkit.createText(basicSectionClient, "", 2052);
        GridData folderTextData = new GridData(4, 1, true, false);
        folderTextData.horizontalSpan = 2;
        this.fGroupFolderInputTextField.setToolTipText("The Location (Folder) where the Review Group Information is Stored.  Review Group Information is stored in files that have a _group_root.xrer suffix");
        this.fGroupFolderInputTextField.setLayoutData((Object)folderTextData);
        Button folderButton = toolkit.createButton(basicSectionClient, "", 0);
        folderButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER").createImage());
        textGridData = new GridData(1, 1, false, false);
        textGridData.horizontalSpan = 1;
        folderButton.setToolTipText("Browse Folders...");
        folderButton.setLayoutData((Object)textGridData);
        folderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String result = ReviewGroupInputDialog.this.folderButtonPressed();
                if (result == null) {
                    ReviewGroupInputDialog.this.fGroupFolderInputTextField.setText("");
                } else {
                    ReviewGroupInputDialog.this.fGroupFolderInputTextField.setText(result);
                }
            }
        });
        this.fGroupFolderInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ReviewGroupInputDialog.this.fGroupNameInputTextField.getText().length() > 0 && ReviewGroupInputDialog.this.fGroupFolderInputTextField.getText().length() > 0 && ReviewGroupInputDialog.this.fGroupDescriptionInputTextField.getText().length() > 0) {
                    ReviewGroupInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    ReviewGroupInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        label = toolkit.createLabel(basicSectionClient, ADD_REVIEW_GROUP_DESCRIPTION_DIALOG_VALUE);
        label.setToolTipText("A Brief Description of ths Review Group");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fGroupDescriptionInputTextField = toolkit.createText(basicSectionClient, "", 2562);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        textGridData.heightHint = this.fGroupNameInputTextField.getLineHeight() * 3;
        this.fGroupDescriptionInputTextField.setToolTipText("A Brief Description of ths Review Group");
        this.fGroupDescriptionInputTextField.setLayoutData((Object)textGridData);
        this.fGroupDescriptionInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ReviewGroupInputDialog.this.fGroupNameInputTextField.getText().length() > 0 && ReviewGroupInputDialog.this.fGroupFolderInputTextField.getText().length() > 0 && ReviewGroupInputDialog.this.fGroupDescriptionInputTextField.getText().length() > 0) {
                    ReviewGroupInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    ReviewGroupInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        Section extraSection = toolkit.createSection(composite, 386);
        extraSection.setLayout((Layout)new GridLayout());
        extraSection.setLayoutData((Object)new GridData(4, 4, true, true));
        extraSection.setText("Extra Parameters");
        extraSection.setDescription(EXTRA_PARAMS_HEADER_MSG);
        extraSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ReviewGroupInputDialog.this.getShell().setSize(ReviewGroupInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite extraSectionClient = toolkit.createComposite((Composite)extraSection);
        extraSectionClient.setLayout((Layout)new GridLayout(4, false));
        extraSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        extraSection.setClient((Control)extraSectionClient);
        label = toolkit.createLabel(extraSectionClient, ADD_REVIEW_GROUP_AVAILABLE_PROJECTS_DIALOG_VALUE);
        label.setToolTipText("The Projects that are available for Review in this Review Group.  Take Note that these Project can have Arbitrary Names, not only Eclipse Project Names");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fAvailableProjects = new EditableListWidget(toolkit, extraSectionClient, textGridData, null, 0, Text.class, null);
        this.fAvailableProjects.setToolTipText("The Projects that are available for Review in this Review Group.  Take Note that these Project can have Arbitrary Names, not only Eclipse Project Names");
        label = toolkit.createLabel(extraSectionClient, ADD_REVIEW_GROUP_AVAILABLE_COMPONENTS_DIALOG_VALUE);
        label.setToolTipText("The Components (Subsystems, Sub-Projects etc.) that are available for Review in this Review Group.  These can have Arbitrary Names");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fAvailableComponents = new EditableListWidget(toolkit, extraSectionClient, textGridData, null, 0, Text.class, null);
        this.fAvailableComponents.setToolTipText("The Components (Subsystems, Sub-Projects etc.) that are available for Review in this Review Group.  These can have Arbitrary Names");
        label = toolkit.createLabel(extraSectionClient, ADD_REVIEW_GROUP_ENTRY_CRITERIA_DIALOG_VALUE);
        label.setToolTipText("The Entry Criteria that will be used for all Reviews created under this Review Group");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fDefaultEntryCriteriaTextField = toolkit.createText(extraSectionClient, "", 2562);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        textGridData.heightHint = this.fGroupNameInputTextField.getLineHeight() * 3;
        this.fDefaultEntryCriteriaTextField.setToolTipText("The Entry Criteria that will be used for all Reviews created under this Review Group");
        this.fDefaultEntryCriteriaTextField.setLayoutData((Object)textGridData);
        label = toolkit.createLabel(extraSectionClient, ADD_RULE_SETS_DIALOG_VALUE);
        label.setToolTipText("The Location of the RuleSet definition Files that can be used for Reviews created under this Review Group");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        List<R4EUIRuleSet> uiRuleSets = R4EUIModelController.getRootElement().getRuleSets();
        ArrayList<String> ruleLocations = new ArrayList<String>();
        for (R4EUIRuleSet ruleSet : uiRuleSets) {
            ruleLocations.add(ruleSet.getRuleSet().getName());
        }
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fRuleSets = new EditableListWidget(toolkit, extraSectionClient, textGridData, null, 0, CCombo.class, ruleLocations.toArray(new String[ruleLocations.size()]));
        if (ruleLocations.size() == 0) {
            this.fRuleSets.setEnabled(false);
        }
        this.fRuleSets.setToolTipText("The Location of the RuleSet definition Files that can be used for Reviews created under this Review Group");
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    protected String folderButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0x10000000);
        dialog.setMessage("Select Folder...");
        String dir = dialog.open();
        if (dir != null && (dir = dir.trim()).length() == 0) {
            return null;
        }
        return dir;
    }

    protected boolean isResizable() {
        return true;
    }

    public String getGroupNameValue() {
        return this.fGroupNameValue;
    }

    public String getGroupFolderValue() {
        return this.fGroupFolderValue;
    }

    public String getGroupDescriptionValue() {
        return this.fGroupDescriptionValue;
    }

    public String[] getAvailableProjectsValues() {
        return this.fAvailableProjectsValues;
    }

    public String[] getAvailableComponentsValues() {
        return this.fAvailableComponentsValues;
    }

    public String getDefaultEntryCriteriaValue() {
        return this.fDefaultEntryCriteriaValue;
    }

    public String[] getRuleSetValues() {
        return this.fRuleSetsValues;
    }

    protected String validateFolderInput(Text aText) {
        return ((R4EInputValidator)this.fValidator).isFolderValid(aText.getText());
    }

    private String validateGroupExists(Text aText) {
        return ((R4EInputValidator)this.fValidator).isFolderEmpty(aText.getText());
    }

    private String validateEmptyInput(Text aText) {
        return this.fValidator.isValid(aText.getText());
    }

    private String validateEmptyInput(String aString) {
        return this.fValidator.isValid(aString);
    }
}

