/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.mail.smtp.mailVersion;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.reviews.notifications.core.IMeetingData;
import org.eclipse.mylyn.reviews.notifications.core.NotificationFilter;
import org.eclipse.mylyn.reviews.notifications.core.NotificationsCore;
import org.eclipse.mylyn.reviews.notifications.spi.NotificationsConnector;
import org.eclipse.mylyn.reviews.r4e.mail.smtp.mailVersion.MailDialog;
import org.eclipse.mylyn.reviews.r4e.mail.smtp.mailVersion.internal.MailData;
import org.eclipse.mylyn.reviews.r4e.mail.smtp.mailVersion.internal.SMTPHostString;
import org.eclipse.mylyn.reviews.r4e.mail.smtp.mailVersion.internal.dialogs.ScheduleMeetingInputDialog;
import org.eclipse.mylyn.reviews.r4e.mail.smtp.mailVersion.internal.preferences.SmtpHostPreferencePage;
import org.eclipse.mylyn.reviews.vcalendar.core.VCalendar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class Smtp
extends NotificationsConnector {
    public Smtp() {
        this.setEnable();
    }

    private void setEnable() {
        this.enabled = true;
    }

    public Boolean sendEmail(String aEmailFrom, String[] aEmailsTo, String aSubject, String aBody, String aAttachment, NotificationFilter aFilter) throws CoreException {
        String[] smtpHost = this.getSMTPHost();
        int numHost = smtpHost.length;
        int i = 0;
        while (i < numHost) {
            if (smtpHost[i].trim().length() == 0) {
                ErrorDialog dialog = new ErrorDialog(null, SMTPHostString.getString("dialog_title_error"), SMTPHostString.getString("smtp_emtpy_server"), (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.mail.smtp", 0, "You should define the SMTP server under \n Window -> Preferences-> R4E-> SMTP Host, \n No E-mail sent", null), 4);
                dialog.open();
                return false;
            }
            try {
                Smtp.createAndSendEmail(smtpHost[i], aEmailFrom, aEmailsTo, aSubject, aBody, aAttachment);
                break;
            }
            catch (MessagingException aEex) {
                if (i + 1 >= numHost) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("ComponentObjectModelException: ");
                    sb.append(aEex.getMessage());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.mail.smtp", sb.toString()){});
                }
                ++i;
            }
        }
        return true;
    }

    public void sendEmailGraphical(String aEmailFrom, String[] aEmailsTo, String aSubject, String aBody, String aAttachment, NotificationFilter aFilter) throws CoreException {
        MailDialog mailD = new MailDialog(this.getShell());
        mailD.create();
        mailD.setMailInfo(aEmailsTo, aSubject, aBody, aAttachment);
        int ok = mailD.open();
        if (ok == 0) {
            MailData mailData = mailD.getEmailData();
            this.sendEmail(aEmailFrom, mailData.getSendTo(), mailData.getSubject(), mailData.getBody(), mailData.getAttachment(), aFilter);
        }
    }

    public IMeetingData createMeetingRequest(String aSubject, String aBody, String[] aEmailsTo, Long aStartDate, Integer aDuration, String aLocation) throws CoreException {
        IMeetingData r4eMeetingData = null;
        ScheduleMeetingInputDialog dialog = new ScheduleMeetingInputDialog(this.getShell());
        dialog.create();
        dialog.setStartTime(aStartDate);
        dialog.setDuration(aDuration);
        dialog.setLocation(aLocation);
        int result = dialog.open();
        if (result == 0) {
            String customID = String.valueOf(aSubject) + System.currentTimeMillis();
            String defaultUserId = System.getProperty("user.name");
            r4eMeetingData = NotificationsCore.createMeetingData((String)customID, (String)aSubject, (String)aBody, (String)dialog.getLocation(), (long)dialog.getStartTime(), (int)dialog.getDuration(), (String)defaultUserId, (String[])aEmailsTo);
            VCalendar vcal = new VCalendar();
            String vcalAttachment = vcal.createVCalendar(r4eMeetingData, defaultUserId, aEmailsTo);
            Boolean ok = this.sendEmail(defaultUserId, aEmailsTo, r4eMeetingData.getSubject(), r4eMeetingData.getBody(), vcalAttachment, null);
            if (!ok.booleanValue()) {
                r4eMeetingData = null;
            }
        }
        return r4eMeetingData;
    }

    public IMeetingData openAndUpdateMeeting(IMeetingData aMeetingData, Date aSearchFrom, boolean aForceUpdate) {
        IMeetingData newMeetingData = null;
        ScheduleMeetingInputDialog dialog = new ScheduleMeetingInputDialog(this.getShell());
        dialog.create();
        Long zoneStartTime = (long)aMeetingData.getStartTime();
        dialog.setStartTime(zoneStartTime);
        dialog.setDuration(aMeetingData.getDuration());
        dialog.setLocation(aMeetingData.getLocation());
        int result = dialog.open();
        if (result == 0) {
            String defaultUserId = System.getProperty("user.name");
            try {
                newMeetingData = NotificationsCore.createMeetingData((String)aMeetingData.getCustomID(), (String)aMeetingData.getSubject(), (String)aMeetingData.getBody(), (String)dialog.getLocation(), (long)dialog.getStartTime(), (int)dialog.getDuration(), (String)aMeetingData.getSender(), (String[])aMeetingData.getReceivers());
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.mail.smtp", 0, e.toString(), (Throwable)e));
            }
            VCalendar vcal = new VCalendar();
            String vcalAttachment = vcal.createVCalendar(newMeetingData, defaultUserId, aMeetingData.getReceivers());
            if (newMeetingData != null) {
                try {
                    Boolean ok = this.sendEmail(defaultUserId, newMeetingData.getReceivers(), newMeetingData.getSubject(), newMeetingData.getBody(), vcalAttachment, null);
                    if (!ok.booleanValue()) {
                        newMeetingData = null;
                    }
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.mail.smtp", 0, e.toString(), (Throwable)e));
                }
            }
        }
        return newMeetingData;
    }

    public IMeetingData fetchSystemMeetingData(IMeetingData aLocalData, Date aSearchFrom) {
        return aLocalData;
    }

    private static void createAndSendEmail(String aSMTPServer, String aFrom, String[] aEmails, String aSubject, String aBody, String aAttachment) throws MessagingException {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", aSMTPServer);
        Session session = Session.getInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session);
        if (aFrom != null && aFrom != "") {
            msg.setFrom((Address)new InternetAddress(aFrom));
        }
        String[] stringArray = aEmails;
        int n = aEmails.length;
        int n2 = 0;
        while (n2 < n) {
            String aEmail = stringArray[n2];
            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(aEmail));
            ++n2;
        }
        msg.setSubject(aSubject);
        if (aAttachment == null) {
            msg.setText(aBody);
        } else {
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(aBody);
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            messageBodyPart = new MimeBodyPart();
            messageBodyPart.setFileName("review calendar.vcs");
            messageBodyPart.setContent((Object)aAttachment, "text/plain");
            multipart.addBodyPart((BodyPart)messageBodyPart);
            msg.setContent((Multipart)multipart);
        }
        msg.setSentDate(new Date());
        Transport.send((Message)msg);
    }

    private Shell getShell() {
        Shell sh = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        return sh;
    }

    private String[] getSMTPHost() {
        String[] host = null;
        SmtpHostPreferencePage prefOrder = new SmtpHostPreferencePage();
        host = prefOrder.getSmtpServer();
        return host;
    }
}

