/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EDelta;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.R4ETextPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContentsContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIDelta;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUITextPosition;

public class R4EUIDeltaContainer
extends R4EUIContentsContainer {
    public static final String DELTA_CONTAINER_ICON_FILE = "icons/obj16/deltacont_obj.gif";

    public R4EUIDeltaContainer(IR4EUIModelElement aParent, String aName) {
        super(aParent, aName);
    }

    public String getImageLocation() {
        return DELTA_CONTAINER_ICON_FILE;
    }

    public R4EUIDelta createDelta(R4EUITextPosition aUiPosition) throws ResourceHandlingException, OutOfSyncException {
        R4EDelta delta = R4EUIModelController.FModelExt.createR4EDelta(((R4EUIFileContext)this.getParent()).getFileContext());
        R4ETextPosition position = R4EUIModelController.FModelExt.createR4ETextPosition(R4EUIModelController.FModelExt.createR4ETargetTextContent(delta));
        aUiPosition.setPositionInModel((R4EPosition)position);
        R4EUIDelta uiDelta = new R4EUIDelta(this, delta, aUiPosition);
        this.addChildren(uiDelta);
        return uiDelta;
    }

    public void open() {
        EList deltas = ((R4EUIFileContext)this.getParent()).getFileContext().getDeltas();
        if (deltas != null) {
            R4EUITextPosition position = null;
            R4EUIDelta newDelta = null;
            int deltaSize = deltas.size();
            R4EDelta delta = null;
            int i = 0;
            while (i < deltaSize) {
                delta = (R4EDelta)deltas.get(i);
                if (delta.isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                    position = new R4EUITextPosition(((R4EDelta)deltas.get(i)).getTarget().getLocation());
                    newDelta = new R4EUIDelta(this, (R4EDelta)deltas.get(i), position);
                    this.addChildren(newDelta);
                }
                ++i;
            }
        }
        this.fOpen = true;
    }
}

