/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.reviews.frame.core.model.Location;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.frame.core.model.SubModelRoot;
import org.eclipse.mylyn.reviews.frame.core.model.Topic;
import org.eclipse.mylyn.reviews.ldap.LdapPlugin;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyTextPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EContent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileContext;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewGroup;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleCollection;
import org.eclipse.mylyn.reviews.r4e.core.model.impl.R4EItemImpl;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.SerializeFactory;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.commands.ReviewState;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRootElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorActionGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorView;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed.ModelElementTabPropertySection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.services.IEvaluationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIModelController {
    private static R4EUIRootElement FRootElement = null;
    private static boolean FIsDialogOpen = false;
    private static R4EUIReviewBasic FActiveReview = null;
    private static ReviewState FReviewSourceProvider = null;
    private static ReviewNavigatorView FView = null;
    private static String FReviewer = null;
    public static Persistence.RModelFactoryExt FModelExt;
    public static Persistence.ResourceUpdater FResourceUpdater;
    private static final Map<String, List<R4EAnomaly>> FFileAnomalyMap;
    private static IR4EUIModelElement FFocusElement;
    private static ModelElementTabPropertySection FCurrentPropertySection;

    static {
        FFileAnomalyMap = new HashMap<String, List<R4EAnomaly>>(32, 0.75f);
        FFocusElement = null;
        FCurrentPropertySection = null;
    }

    public static void setNavigatorView(ReviewNavigatorView aView) {
        FView = aView;
    }

    public static ReviewNavigatorView getNavigatorView() {
        return FView;
    }

    public static void setReviewCommandSourceProvider(ReviewState aSourceProvider) {
        FReviewSourceProvider = aSourceProvider;
    }

    public static R4EUIRootElement getRootElement() {
        return FRootElement;
    }

    public static void setActiveReview(R4EUIReviewBasic aActiveReview) {
        ReviewNavigatorActionGroup actionGroup;
        FActiveReview = aActiveReview;
        if (FReviewSourceProvider != null) {
            FReviewSourceProvider.setCurrentReview(FActiveReview);
        }
        if ((actionGroup = (ReviewNavigatorActionGroup)FView.getActionSet()).isMyReviewFilterSet()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        actionGroup.runReviewsMyFilterCommand(true);
                    }
                    catch (ExecutionException e) {
                        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                    }
                    catch (NotDefinedException e) {
                        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                    }
                    catch (NotEnabledException e) {
                        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                    }
                    catch (NotHandledException e) {
                        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                    }
                }
            });
        }
        if (actionGroup.isParticipantFilterSet()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        actionGroup.runReviewsParticipantFilterCommand(actionGroup.getReviewFilterParticipant());
                    }
                    catch (ExecutionException e) {
                        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                    }
                    catch (NotDefinedException e) {
                        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                    }
                    catch (NotEnabledException e) {
                        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                    }
                    catch (NotHandledException e) {
                        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                    }
                }
            });
        }
    }

    public static void setJobInProgress(boolean aIsDialogOpen) {
        FIsDialogOpen = aIsDialogOpen;
        final IEvaluationService service = (IEvaluationService)FView.getSite().getService(IEvaluationService.class);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                service.requestEvaluation("org.eclipse.mylyn.reviews.r4e.ui.commands.dialogOpen");
                R4EUIModelController.getNavigatorView().refreshItems();
            }
        });
    }

    public static R4EUIReviewBasic getActiveReview() {
        return FActiveReview;
    }

    public static boolean isJobInProgress() {
        return FIsDialogOpen;
    }

    public static R4EReviewGroup peekReviewGroup(String aFilePath) throws ResourceHandlingException, CompatibilityException {
        FModelExt = SerializeFactory.getModelExtension();
        return FModelExt.openR4EReviewGroup(URI.createFileURI((String)aFilePath));
    }

    public static R4EDesignRuleCollection peekRuleSet(String aFilePath) throws ResourceHandlingException, CompatibilityException {
        FModelExt = SerializeFactory.getModelExtension();
        return FModelExt.openR4EDesignRuleCollection(URI.createFileURI((String)aFilePath));
    }

    public static void loadModel() {
        FModelExt = SerializeFactory.getModelExtension();
        FResourceUpdater = SerializeFactory.getResourceUpdater();
        R4EUIModelController.setReviewer(R4EUIPlugin.getDefault().getPreferenceStore().getString("userIdPreference"));
        FRootElement = new R4EUIRootElement(null, "R4E");
        List<String> loadErrors = new ArrayList<String>();
        IPreferenceStore preferenceStore = R4EUIPlugin.getDefault().getPreferenceStore();
        String groupPaths = preferenceStore.getString("groupFilePathPreference");
        List<String> groupPathsList = UIUtils.parseStringList(groupPaths);
        loadErrors = R4EUIModelController.loadReviewGroups(groupPathsList, loadErrors);
        String ruleSetPaths = preferenceStore.getString("ruleSetFilePathPreference");
        List<String> ruleSetPathsList = UIUtils.parseStringList(ruleSetPaths);
        loadErrors = R4EUIModelController.loadRuleSets(ruleSetPathsList, loadErrors);
        if (loadErrors.size() > 0) {
            UIUtils.displayFailedLoadDialog(loadErrors);
        }
    }

    public static List<String> loadReviewGroups(List<String> aGroupPaths, List<String> aErrors) {
        for (String groupPath : aGroupPaths) {
            try {
                File groupFile = new File(groupPath);
                if (!groupFile.exists()) {
                    aErrors.add("Invalid Group Path " + groupPath + R4EUIConstants.LINE_FEED);
                    continue;
                }
                FRootElement.loadReviewGroup(groupPath);
            }
            catch (ResourceHandlingException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                aErrors.add(String.valueOf(e.getMessage()) + R4EUIConstants.LINE_FEED);
            }
            catch (CompatibilityException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                aErrors.add(String.valueOf(e.getMessage()) + R4EUIConstants.LINE_FEED);
            }
            catch (IOException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                aErrors.add(String.valueOf(e.getMessage()) + R4EUIConstants.LINE_FEED);
            }
        }
        return aErrors;
    }

    public static List<String> loadRuleSets(List<String> aRuleSetPaths, List<String> aErrors) {
        for (String ruleSetPath : aRuleSetPaths) {
            try {
                File ruleSetFile = new File(ruleSetPath);
                if (!ruleSetFile.exists()) {
                    aErrors.add("Invalid Ruleset Path " + ruleSetPath + R4EUIConstants.LINE_FEED);
                    continue;
                }
                FRootElement.loadRuleSet(ruleSetPath);
            }
            catch (ResourceHandlingException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                aErrors.add(String.valueOf(e.getMessage()) + R4EUIConstants.LINE_FEED);
            }
            catch (CompatibilityException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                aErrors.add(String.valueOf(e.getMessage()) + R4EUIConstants.LINE_FEED);
            }
            catch (IOException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                aErrors.add(String.valueOf(e.getMessage()) + R4EUIConstants.LINE_FEED);
            }
        }
        return aErrors;
    }

    public static void stampVersion(ReviewComponent aReviewComponent, String aUpdater, String aNewVersion) throws ResourceHandlingException, OutOfSyncException {
        if (aReviewComponent instanceof SubModelRoot) {
            Long bookNum = SerializeFactory.getResourceUpdater().checkOut((EObject)aReviewComponent, aUpdater);
            ((SubModelRoot)aReviewComponent).setFragmentVersion(aNewVersion);
            SerializeFactory.getResourceUpdater().checkIn(bookNum);
        }
    }

    public static void mapAnomalies(R4EReview aReview) {
        R4EUIModelController.clearAnomalyMap();
        EList anomalies = aReview.getTopics();
        Topic anomaly = null;
        EList locations = null;
        String targetFileVersion = null;
        int anomaliesSize = anomalies.size();
        int i = 0;
        while (i < anomaliesSize) {
            anomaly = (Topic)anomalies.get(i);
            locations = anomaly.getLocation();
            for (Location location : locations) {
                List<Object> anomalyList;
                targetFileVersion = ((R4EAnomalyTextPosition)((R4EContent)location).getLocation()).getFile().getLocalVersionID();
                if (FFileAnomalyMap.containsKey(targetFileVersion)) {
                    anomalyList = FFileAnomalyMap.get(targetFileVersion);
                    if (anomalyList.contains(anomaly)) continue;
                    anomalyList.add((R4EAnomaly)anomaly);
                    continue;
                }
                anomalyList = new ArrayList();
                anomalyList.add((R4EAnomaly)anomaly);
                FFileAnomalyMap.put(targetFileVersion, anomalyList);
            }
            ++i;
        }
    }

    public static void clearAnomalyMap() {
        Set<String> keys = FFileAnomalyMap.keySet();
        for (String key : keys) {
            List<R4EAnomaly> anomaliesList = FFileAnomalyMap.get(key);
            anomaliesList.clear();
        }
        FFileAnomalyMap.clear();
    }

    public static List<R4EAnomaly> getAnomaliesForFile(String aFilePath) {
        return FFileAnomalyMap.get(aFilePath);
    }

    public static List<R4EAnomaly> getAnomaliesForFileIfMostRecent(R4EFileContext aFileSelected, R4EUIReviewItem aSingleReviewItem) {
        R4EItemImpl selectContainer;
        Date datefound;
        String selectedFileVersionId = aFileSelected.getTarget().getLocalVersionID();
        R4EItemImpl reviewItem = (R4EItemImpl)aFileSelected.eContainer();
        Date dateSelected = reviewItem.getSubmitted();
        if (dateSelected == null) {
            return FFileAnomalyMap.get(selectedFileVersionId);
        }
        R4EUIReviewBasic review = (R4EUIReviewBasic)aSingleReviewItem.getParent();
        List<R4EUIReviewItem> listReviewItems = review.getItems();
        int reviewItemsize = listReviewItems.size();
        String targetVersionId = null;
        R4EFileContext latestFileContext = null;
        int j = 0;
        while (j < reviewItemsize) {
            Date testDate;
            EList listFile = listReviewItems.get(j).getItem().getFileContextList();
            int size = listFile.size();
            Date date = testDate = listFile.get(0) != null ? ((R4EItemImpl)((R4EFileContext)listFile.get(0)).eContainer()).getSubmitted() : null;
            if (testDate != null) {
                if (testDate.after(dateSelected)) {
                    int k = 0;
                    while (k < size) {
                        R4EFileVersion targetFile = ((R4EFileContext)listFile.get(k)).getTarget();
                        if (targetFile != null && (targetVersionId = ((R4EFileContext)listFile.get(k)).getTarget().getLocalVersionID()).equals(selectedFileVersionId)) {
                            return null;
                        }
                        ++k;
                    }
                } else if (testDate.equals(dateSelected)) {
                    latestFileContext = (R4EFileContext)listFile.get(0);
                }
            }
            ++j;
        }
        if (latestFileContext != null && (datefound = (selectContainer = (R4EItemImpl)latestFileContext.eContainer()).getSubmitted()).equals(dateSelected)) {
            return FFileAnomalyMap.get(selectedFileVersionId);
        }
        return null;
    }

    public static String getReviewer() {
        return FReviewer;
    }

    public static void setReviewer(String aReviewer) {
        FReviewer = aReviewer;
    }

    public static boolean isUserQueryAvailable() {
        return Platform.getBundle((String)"org.eclipse.mylyn.reviews.ldap") != null && LdapPlugin.getDefault().getPreferenceStore().getString("hostIdPreference").length() > 0 && LdapPlugin.getDefault().getPreferenceStore().getString("portIdPreference").length() > 0;
    }

    public static void setCurrentFocusElement(IR4EUIModelElement aElement) {
        FFocusElement = aElement;
    }

    public static IR4EUIModelElement getCurrentFocusElement() {
        return FFocusElement;
    }

    public static void setCurrentPropertySection(ModelElementTabPropertySection aSection) {
        FCurrentPropertySection = aSection;
    }

    public static ModelElementTabPropertySection getCurrentPropertySection() {
        return FCurrentPropertySection;
    }

    public static void stopSerialization(Resource aResource) {
        SerializeFactory.getResourceSerializationRegistry().addSerializationInactive(aResource);
    }

    public static void startSerialization(Resource aResource) {
        SerializeFactory.getResourceSerializationRegistry().removeSerializationInactive(aResource);
    }

    public static void resetToDefaultSerialization() {
        SerializeFactory.getResourceSerializationRegistry().clearSerializationInactive();
    }
}

