/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyTextPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EContent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileContext;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.IRFSRegistry;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.RFSRegistryFactory;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.ReviewsFileStorageException;
import org.eclipse.mylyn.reviews.r4e.core.utils.ResourceUtils;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedAnomaly;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUITextPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.PostponedFileProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.views.properties.IPropertySource;

public class R4EUIPostponedFile
extends R4EUIFileContext {
    public static final String POSTPONED_FILE_ICON_FILE = "icons/obj16/postfile_obj.gif";
    private final List<R4EUIPostponedAnomaly> fUiAnomalies = new ArrayList<R4EUIPostponedAnomaly>();

    public R4EUIPostponedFile(IR4EUIModelElement aParent, R4EFileContext aFile) {
        super(aParent, aFile, 2);
        this.setImage(POSTPONED_FILE_ICON_FILE);
    }

    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new PostponedFileProperties(this);
        }
        return null;
    }

    public String getImageLocation() {
        return POSTPONED_FILE_ICON_FILE;
    }

    public R4EFileVersion getBaseFileVersion() {
        return this.fFile.getTarget();
    }

    public R4EFileVersion getTargetFileVersion() {
        List<R4EUIReviewItem> items = R4EUIModelController.getActiveReview().getReviewItems();
        for (R4EUIReviewItem item : items) {
            List<R4EUIFileContext> files = item.getFileContexts();
            for (R4EUIFileContext file : files) {
                if (file instanceof R4EUIPostponedFile || file.getTargetFileVersion() == null || file.getTargetFileVersion().getPlatformURI() == null || !file.getTargetFileVersion().getPlatformURI().equals(this.fFile.getTarget().getPlatformURI())) continue;
                return file.getTargetFileVersion();
            }
        }
        return null;
    }

    public boolean hasChildren() {
        return this.fUiAnomalies.size() > 0;
    }

    public void close() {
        R4EUIPostponedAnomaly anomaly = null;
        int anomaliesSize = this.fUiAnomalies.size();
        int i = 0;
        while (i < anomaliesSize) {
            anomaly = this.fUiAnomalies.get(i);
            anomaly.close();
            ++i;
        }
        this.fUiAnomalies.clear();
        this.fOpen = false;
    }

    public void open() {
        IRFSRegistry revRegistry = null;
        try {
            revRegistry = RFSRegistryFactory.getRegistry((R4EReview)((R4EUIReviewBasic)this.getParent().getParent()).getReview());
        }
        catch (ReviewsFileStorageException e1) {
            R4EUIPlugin.Ftracer.traceInfo("Exception: " + e1.toString() + " (" + e1.getMessage() + ")");
            R4EUIPlugin.getDefault().logInfo("Exception: " + e1.toString(), (Exception)((Object)e1));
        }
        R4EFileVersion targetFileVersion = this.fFile.getTarget();
        if (targetFileVersion != null) {
            try {
                IFile targetFile = ResourceUtils.toIFile((String)targetFileVersion.getPlatformURI());
                targetFileVersion.setResource((IResource)targetFile);
            }
            catch (FileNotFoundException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                targetFileVersion.setResource(null);
            }
            targetFileVersion.setFileRevision(null);
            if (revRegistry != null) {
                try {
                    IFileRevision fileRev = revRegistry.getIFileRevision(null, targetFileVersion);
                    targetFileVersion.setFileRevision(fileRev);
                }
                catch (ReviewsFileStorageException e) {
                    R4EUIPlugin.Ftracer.traceInfo("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }
        }
        R4EUIPostponedAnomaly uiAnomaly = null;
        R4EUITextPosition position = null;
        this.fAnomalies = R4EUIModelController.getAnomaliesForFile(this.fFile.getTarget().getLocalVersionID());
        int anomaliesSize = this.fAnomalies != null ? this.fAnomalies.size() : 0;
        R4EAnomaly anomaly = null;
        int i = 0;
        while (i < anomaliesSize) {
            anomaly = (R4EAnomaly)this.fAnomalies.get(i);
            if (anomaly.getInfoAtt().get((Object)"originalAnomalyId") != null && (anomaly.isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled"))) {
                position = null;
                EList locations = anomaly.getLocation();
                if (locations != null && locations.get(0) != null) {
                    int locationsSize = locations.size();
                    int j = 0;
                    while (j < locationsSize) {
                        position = new R4EUITextPosition(((R4EContent)anomaly.getLocation().get(j)).getLocation());
                        uiAnomaly = new R4EUIPostponedAnomaly(this, anomaly, position);
                        uiAnomaly.setName(String.valueOf(R4EUIAnomalyExtended.getStateString(anomaly.getState())) + ": " + uiAnomaly.getName());
                        this.addChildren(uiAnomaly);
                        if (uiAnomaly.isEnabled()) {
                            uiAnomaly.open();
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public IR4EUIModelElement[] getChildren() {
        return this.fUiAnomalies.toArray(new R4EUIPostponedAnomaly[this.fUiAnomalies.size()]);
    }

    public void addChildren(IR4EUIModelElement aChildToAdd) {
        if (aChildToAdd instanceof R4EUIPostponedAnomaly) {
            this.fUiAnomalies.add((R4EUIPostponedAnomaly)aChildToAdd);
        }
    }

    public R4EUIPostponedAnomaly createAnomaly(R4EAnomaly aPostponedAnomaly, String aOrigReviewName) throws ResourceHandlingException, OutOfSyncException {
        R4EUIReviewBasic uiReview = R4EUIModelController.getActiveReview();
        R4EParticipant participant = uiReview.getParticipant(aPostponedAnomaly.getUser().getId(), false);
        boolean isParticipant = true;
        if (participant == null) {
            participant = uiReview.getParticipant(aPostponedAnomaly.getUser().getId(), true);
            isParticipant = false;
        }
        List<R4EAnomaly> savedAnomalies = R4EUIModelController.getAnomaliesForFile(this.fFile.getTarget().getLocalVersionID());
        R4EAnomaly anomaly = null;
        R4EUITextPosition uiPosition = null;
        if (savedAnomalies != null) {
            for (R4EAnomaly savedAnomaly : savedAnomalies) {
                String postponedAnomalyId;
                if (savedAnomaly.getInfoAtt().get((Object)"originalAnomalyId") == null || !(postponedAnomalyId = CommandUtils.buildOriginalAnomalyID(aPostponedAnomaly)).equals(savedAnomaly.getInfoAtt().get((Object)"originalAnomalyId"))) continue;
                anomaly = savedAnomaly;
                uiPosition = new R4EUITextPosition((R4EPosition)CommandUtils.getAnomalyPosition(anomaly));
            }
        }
        if (anomaly == null) {
            anomaly = R4EUIModelController.FModelExt.createR4EAnomaly(participant);
            CommandUtils.copyAnomalyData(anomaly, aPostponedAnomaly);
            EMap info = anomaly.getInfoAtt();
            info.put((Object)"originalAnomalyId", (Object)CommandUtils.buildOriginalAnomalyID(aPostponedAnomaly));
            info.put((Object)"originalReviewName", (Object)aOrigReviewName);
            R4EAnomalyTextPosition position = R4EUIModelController.FModelExt.createR4EAnomalyTextPosition((R4EContent)R4EUIModelController.FModelExt.createR4ETextContent(anomaly));
            uiPosition = new R4EUITextPosition((R4EPosition)CommandUtils.getAnomalyPosition(aPostponedAnomaly));
            uiPosition.setPositionInModel((R4EPosition)position);
            R4EFileVersion postponedAnomalyFileVersion = CommandUtils.getAnomalyParentFile(aPostponedAnomaly);
            R4EFileVersion anomalyFileVersion = R4EUIModelController.FModelExt.createR4EFileVersion(position);
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)anomalyFileVersion, R4EUIModelController.getReviewer());
            CommandUtils.copyFileVersionData(anomalyFileVersion, postponedAnomalyFileVersion);
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
        R4EUIPostponedAnomaly uiAnomaly = new R4EUIPostponedAnomaly(this, anomaly, uiPosition);
        uiAnomaly.updateState(aPostponedAnomaly.getState());
        uiAnomaly.setEnabled(true);
        this.addChildren(uiAnomaly);
        if (!isParticipant) {
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)participant, R4EUIModelController.getReviewer());
            participant.setEnabled(false);
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
        if (this.fAnomalies == null) {
            this.fAnomalies = new ArrayList();
        }
        this.fAnomalies.add(anomaly);
        return uiAnomaly;
    }

    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        if (aChildToRemove instanceof R4EUIPostponedAnomaly) {
            R4EUIPostponedAnomaly removedElement = this.fUiAnomalies.get(this.fUiAnomalies.indexOf(aChildToRemove));
            R4EAnomaly modelAnomaly = removedElement.getAnomaly();
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelAnomaly, R4EUIModelController.getReviewer());
            modelAnomaly.setEnabled(false);
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
            if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                this.fUiAnomalies.remove(removedElement);
            }
        }
    }

    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        for (R4EUIPostponedAnomaly uiAnomaly : this.fUiAnomalies) {
            this.removeChildren(uiAnomaly, aFileRemove);
        }
    }

    public boolean isChangeUserReviewStateCmd() {
        return false;
    }
}

