/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.dialogs;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.search.AllProjectScope;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.actions.Q7ElementLabelProvider;
import org.eclipse.rcptt.ui.commons.ModernElementListSelectionDialog;
import org.eclipse.rcptt.ui.dialogs.DialogUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public abstract class VerificationSelectionDialog
extends ModernElementListSelectionDialog {
    private static final int NEW_ID = 1025;
    private static final int CAPTURE_ID = 1026;
    private IVerification[] allVerifications;
    private IVerification[] fromRequiredProjects;
    private final IProject project;
    private final IQ7NamedElement element;
    private Label filterTextLabel;

    public VerificationSelectionDialog(Shell parent, IQ7NamedElement element, IProject project) {
        super(parent, VerificationSelectionDialog.createLabelProvider(element, project));
        this.project = project;
        this.element = element;
        this.setTitle(Messages.VerificationSelectionDialog_Title);
        this.setMessage(Messages.VerificationSelectionDialog_Msg);
        this.setMultipleSelection(true);
        this.setElements(this.hasProject() ? this.getFromRequiredProjects() : this.getAllVerifications());
    }

    private static ILabelProvider createLabelProvider(IQ7NamedElement element, IProject project) {
        return new Q7ElementLabelProvider(false);
    }

    private boolean hasProject() {
        return this.element != null && this.element.getQ7Project() != null && this.element.getQ7Project().exists() || this.project != null;
    }

    private IVerification[] getAllVerifications() {
        if (this.allVerifications == null) {
            IQ7NamedElement[] elements = Q7SearchCore.findAllElements((ISearchScope)new AllProjectScope());
            HashSet<IVerification> result = new HashSet<IVerification>();
            IQ7NamedElement[] iQ7NamedElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7NamedElement verification = iQ7NamedElementArray[n2];
                if (verification instanceof IVerification && this.isValidToAdd((IVerification)verification)) {
                    result.add((IVerification)verification);
                }
                ++n2;
            }
            this.allVerifications = result.toArray(new IVerification[result.size()]);
        }
        return this.allVerifications;
    }

    private IVerification[] getFromRequiredProjects() {
        if (this.fromRequiredProjects == null) {
            IQ7NamedElement[] elements = null;
            elements = this.project == null ? Q7SearchCore.findAllElements((ISearchScope)new ReferencedProjectScope(this.element.getQ7Project())) : Q7SearchCore.findAllElements((ISearchScope)new ReferencedProjectScope(RcpttCore.create((IProject)this.project)));
            HashSet<IVerification> result = new HashSet<IVerification>();
            IQ7NamedElement[] iQ7NamedElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7NamedElement verification = iQ7NamedElementArray[n2];
                if (verification instanceof IVerification && this.isValidToAdd((IVerification)verification)) {
                    result.add((IVerification)verification);
                }
                ++n2;
            }
            this.fromRequiredProjects = result.toArray(new IVerification[result.size()]);
        }
        return this.fromRequiredProjects;
    }

    protected abstract boolean isValidToAdd(IVerification var1);

    public boolean isHelpAvailable() {
        return false;
    }

    private void updateFilteredList(boolean checked) {
        Object[] newElements = checked ? this.getFromRequiredProjects() : this.getAllVerifications();
        this.setListElements(newElements);
    }

    @Override
    protected void handleEmptyList() {
        this.filterTextLabel.setEnabled(false);
        super.handleEmptyList();
    }

    @Override
    protected void handleNonemptyList() {
        this.filterTextLabel.setEnabled(true);
        super.handleNonemptyList();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, Messages.VerificationSelectionDialog_NewButtonText, false).setImage(Images.getImage("icons/verification.gif"));
        this.createButton(parent, 1026, Messages.VerificationSelectionDialog_CaptureButtonText, false).setImage(Images.getImage("icons/camera.png"));
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (1025 == buttonId || 1026 == buttonId) {
            try {
                IVerification verification = DialogUtil.openNewVerificationDialog(this.getShell(), 1026 == buttonId);
                if (verification == null) {
                    return;
                }
                this.setResult(Arrays.asList(verification));
                this.setReturnCode(0);
                this.close();
            }
            catch (Throwable e) {
                Q7UIPlugin.log(e);
            }
        }
        super.buttonPressed(buttonId);
    }

    @Override
    protected Text createFilterText(Composite parent) {
        this.filterTextLabel = new Label(parent, 0);
        this.filterTextLabel.setText(Messages.VerificationSelectionDialog_FilterText);
        GridDataFactory.fillDefaults().applyTo((Control)this.filterTextLabel);
        return super.createFilterText(parent);
    }

    @Override
    protected FilteredList createFilteredList(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.VerificationSelectionDialog_TopLabelText);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        FilteredList list = super.createFilteredList(parent);
        final Button checkbox = new Button(parent, 32);
        checkbox.setText(Messages.VerificationSelectionDialog_ShowCheckboxText);
        boolean hasProject = this.hasProject();
        checkbox.setSelection(hasProject);
        checkbox.setEnabled(hasProject);
        this.updateFilteredList(hasProject);
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VerificationSelectionDialog.this.updateFilteredList(checkbox.getSelection());
            }
        });
        return list;
    }
}

