/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7Status;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.BecomeWorkingCopyOperation;
import org.eclipse.rcptt.internal.core.model.CommitWorkingCopyOperation;
import org.eclipse.rcptt.internal.core.model.DiscardWorkingCopyOperation;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.Openable;
import org.eclipse.rcptt.internal.core.model.OpenableElementInfo;
import org.eclipse.rcptt.internal.core.model.Q7Element;
import org.eclipse.rcptt.internal.core.model.Q7Folder;
import org.eclipse.rcptt.internal.core.model.Q7ResourceInfo;

public abstract class Q7NamedElement
extends Openable
implements IQ7NamedElement {
    protected String name;
    protected boolean workingCopyMode = false;
    protected boolean indexing = false;

    public Q7NamedElement(Q7Element parent, String name) throws IllegalArgumentException {
        super(parent);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public IFile getResource() {
        return ((IContainer)this.getParent().getResource()).getFile((IPath)new Path(this.getName()));
    }

    @Override
    protected Q7ResourceInfo createElementInfo() {
        return new Q7ResourceInfo("--- RCPTT testcase ---", Q7ResourceInfo.toURI(this.getResource()));
    }

    protected abstract NamedElement createNamedElement();

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, IResource underlyingResource) throws ModelException {
        if (!this.isInWorkingCopyMode() && !underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        Q7ResourceInfo resourceInfo = (Q7ResourceInfo)info;
        IFile resource = this.getResource();
        try {
            resourceInfo.load(resource);
        }
        catch (Throwable e) {
            e.addSuppressed(new IOException("Reading " + String.valueOf(resource)));
            throw e;
        }
        if (this.isInWorkingCopyMode() && !this.indexing && resourceInfo.getNamedElement() == null) {
            resourceInfo.createNamedElement(this.createNamedElement());
        }
        return true;
    }

    @Override
    public IPath getPath() {
        return this.getParent().getPath().append(this.getName());
    }

    @Override
    public String getID() throws ModelException {
        return this.accessResourceInfo(info -> info.getNamedElement().getId());
    }

    @Override
    public String getElementName() throws ModelException {
        return this.accessResourceInfo(info -> info.getNamedElement().getName());
    }

    @Override
    public String getDescription() throws ModelException {
        return this.accessResourceInfo(info -> info.getNamedElement().getDescription());
    }

    @Override
    public String getVersion() throws ModelException {
        return this.accessResourceInfo(info -> info.getNamedElement().getVersion());
    }

    @Override
    public String getTags() throws ModelException {
        return this.accessResourceInfo(info -> info.getNamedElement().getTags());
    }

    public NamedElement getMeta() throws ModelException {
        return this.accessResourceInfo(info -> info.getNamedElement());
    }

    @Override
    public boolean isWorkingCopy() {
        return this.getPerWorkingCopyInfo() != null && this.workingCopyMode;
    }

    private ModelManager.PerWorkingCopyInfo getPerWorkingCopyInfo() {
        return ModelManager.getModelManager().getPerWorkingCopyInfo(this, false, false);
    }

    @Override
    public boolean hasResourceChanged() throws ModelException {
        if (!this.isWorkingCopy()) {
            return false;
        }
        try {
            return this.accessInfoIfOpened(info -> ((Q7ResourceInfo)info).timestamp != this.getResource().getModificationStamp()).orElse(false);
        }
        catch (InterruptedException e) {
            throw new ModelException((Throwable)e, 0);
        }
    }

    @Override
    public IQ7NamedElement getIndexingWorkingCopy(IProgressMonitor monitor) throws ModelException {
        return this.internalGetWorkingCopy(monitor, true);
    }

    @Override
    public IQ7NamedElement getWorkingCopy(IProgressMonitor monitor) throws ModelException {
        return this.internalGetWorkingCopy(monitor, false);
    }

    public IQ7NamedElement internalGetWorkingCopy(IProgressMonitor monitor, boolean indexing) throws ModelException {
        ModelManager manager = ModelManager.getModelManager();
        Q7NamedElement workingCopy = this.createWorkingCopy();
        workingCopy.workingCopyMode = true;
        ModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy, false, true);
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        BecomeWorkingCopyOperation op = new BecomeWorkingCopyOperation(workingCopy, indexing);
        op.runOperation(monitor);
        return workingCopy;
    }

    protected abstract Q7NamedElement createWorkingCopy();

    public void extractAllPersistence() throws ModelException {
        this.accessResourceInfo(info -> {
            info.extractAllPersistence();
            return null;
        });
    }

    @Override
    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws ModelException {
        CommitWorkingCopyOperation op = new CommitWorkingCopyOperation(this, force);
        op.runOperation(monitor);
    }

    @Override
    public void discardWorkingCopy() throws ModelException {
        DiscardWorkingCopyOperation op = new DiscardWorkingCopyOperation(this, this.indexing);
        op.runOperation(null);
    }

    public IQ7NamedElement getPrimary() {
        return ((Q7Folder)this.getParent()).getNamedElement(this.getName());
    }

    public void updateTimeStamp(Q7NamedElement primary) throws ModelException {
        long timeStamp = primary.getResource().getModificationStamp();
        if (timeStamp == -1L) {
            throw new ModelException(new Q7Status(0, "Invalid Resource"));
        }
        try {
            this.accessInfoIfOpened(info -> {
                ((Q7ResourceInfo)info).timestamp = timeStamp;
                return null;
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ModelException((Throwable)e, 0);
        }
    }

    @Override
    public NamedElement getNamedElement() throws ModelException {
        return this.accessResourceInfo(info -> info.getNamedElement());
    }

    @Override
    public NamedElement getModifiedNamedElement() throws ModelException {
        ModelManager.PerWorkingCopyInfo info = this.getPerWorkingCopyInfo();
        if (info != null) {
            return info.resourceInfo.getNamedElement();
        }
        return this.getNamedElement();
    }

    @Override
    public IPersistenceModel getModifiedPersistenceModel() throws ModelException {
        ModelManager.PerWorkingCopyInfo info = this.getPerWorkingCopyInfo();
        if (info != null) {
            return info.resourceInfo.getPersistenceModel();
        }
        return this.getPersistenceModel();
    }

    @Override
    public IPersistenceModel getPersistenceModel() throws ModelException {
        return this.accessResourceInfo(info -> info.getModel());
    }

    @Override
    public void setDescription(String description) throws ModelException {
        this.writeWorkingCopy(info -> info.getNamedElement().setDescription(description));
    }

    @Override
    public void setElementName(String name) throws ModelException {
        this.writeWorkingCopy(info -> info.getNamedElement().setName(name));
    }

    @Override
    public void setID(String id) throws ModelException {
        this.writeWorkingCopy(info -> info.getNamedElement().setId(id));
    }

    @Override
    public void setVersion(String version) throws ModelException {
        this.writeWorkingCopy(info -> info.getNamedElement().setVersion(version));
    }

    @Override
    public void setTags(String tags) throws ModelException {
        this.writeWorkingCopy(info -> info.getNamedElement().setTags(tags));
    }

    @Override
    public boolean hasUnsavedChanges() throws ModelException {
        Q7ResourceInfo info = null;
        if (this.isWorkingCopy() && (info = this.getPerWorkingCopyInfo().resourceInfo) != null) {
            return info.hasChanges();
        }
        try {
            return this.accessInfoIfOpened(info2 -> ((Q7ResourceInfo)info2).hasChanges()).orElse(false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ModelException((Throwable)e, 0);
        }
    }

    public final void writeWorkingCopy(Consumer<Q7ResourceInfo> write) {
        if (!this.isInWorkingCopyMode()) {
            throw new IllegalStateException("This is not a working copy");
        }
        ModelManager.PerWorkingCopyInfo info = this.getPerWorkingCopyInfo();
        if (info == null) {
            throw new IllegalStateException("Working copy is closed");
        }
        write.accept(info.resourceInfo);
    }

    public final <V> V accessResourceInfo(Function<Q7ResourceInfo, V> infoToValue) throws ModelException {
        try {
            ModelManager.PerWorkingCopyInfo info2;
            if (!(this.getResource().getWorkspace().isTreeLocked() || ModelManager.getModelManager().isProjectBuilding() || this.indexing)) {
                try {
                    this.getResource().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    RcpttPlugin.log(e);
                }
            }
            if (!this.getResource().isSynchronized(2)) {
                throw this.newNotPresentException();
            }
            if (this.isInWorkingCopyMode() && (info2 = this.getPerWorkingCopyInfo()) != null) {
                return infoToValue.apply(info2.resourceInfo);
            }
            return (V)this.openAndAccessInfo(info -> {
                Q7ResourceInfo resource = (Q7ResourceInfo)info;
                return infoToValue.apply(resource);
            }, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ModelException((Throwable)e, 0);
        }
    }

    @Override
    protected boolean isInWorkingCopyMode() {
        return this.workingCopyMode;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Q7NamedElement)) {
            return false;
        }
        return super.equals(obj);
    }

    public void updatePersistenceModel(IPersistenceModel newModel) throws ModelException {
        this.writeWorkingCopy(info -> info.updatePersistenceModel(newModel));
    }

    public void setIndexing(boolean indexing) {
        this.indexing = indexing;
    }
}

