/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.rcptt.ui.editors.ecl.ECLEditorPlugin;
import org.eclipse.rcptt.ui.editors.ecl.EclCompositeReconcilingStrategy;
import org.eclipse.rcptt.ui.editors.ecl.EclContentAssistProcessor;
import org.eclipse.rcptt.ui.editors.ecl.EclEditor;
import org.eclipse.rcptt.ui.editors.ecl.EclEditorToolkit;
import org.eclipse.rcptt.ui.editors.ecl.EclFormattingStrategy;
import org.eclipse.rcptt.ui.editors.ecl.EclInformationContol;
import org.eclipse.rcptt.ui.editors.ecl.EclSourceViewer;
import org.eclipse.rcptt.ui.editors.ecl.EclTextHover;
import org.eclipse.rcptt.ui.editors.ecl.EnhancedSourceViewerConfiguration;
import org.eclipse.rcptt.ui.editors.quickfix.EclSourceQuickAssistProcessor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;

public class EclSourceViewerConfiguration
extends EnhancedSourceViewerConfiguration {
    private EclEditor textEditor;

    public EclSourceViewerConfiguration(EclEditor textEditor) {
        super(EclEditorToolkit.getInstance());
        this.textEditor = textEditor;
    }

    public EclSourceViewerConfiguration() {
        super(EclEditorToolkit.getInstance());
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.enableAutoActivation(ECLEditorPlugin.getECLScriptContentAssistActivationState());
        assistant.setAutoActivationDelay(ECLEditorPlugin.getECLScriptContentAssistDelay());
        assistant.setProposalPopupOrientation(11);
        assistant.setContextInformationPopupOrientation(21);
        EclContentAssistProcessor generalContentAssistProcessor = new EclContentAssistProcessor();
        assistant.setContentAssistProcessor((IContentAssistProcessor)generalContentAssistProcessor, "__dftl_partition_content_type");
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant quickAssist = new QuickAssistAssistant();
        quickAssist.setQuickAssistProcessor((IQuickAssistProcessor)new EclSourceQuickAssistProcessor());
        quickAssist.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return quickAssist;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                if (!EclInformationContol.isAvailable(parent)) {
                    return new DefaultInformationControl(parent);
                }
                return new EclInformationContol(parent, false){

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return new AbstractReusableInformationControlCreator(){

                            protected IInformationControl doCreateInformationControl(Shell parent) {
                                if (!EclInformationContol.isAvailable(parent)) {
                                    return new DefaultInformationControl(parent);
                                }
                                return new EclInformationContol(parent, true);
                            }
                        };
                    }
                };
            }
        };
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return 4;
    }

    protected boolean isShowInVerticalRuler(Annotation annotation) {
        return true;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"//", ""};
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new EclTextHover();
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (sourceViewer != null && sourceViewer.isEditable() && sourceViewer instanceof EclSourceViewer) {
            EclCompositeReconcilingStrategy strategy = new EclCompositeReconcilingStrategy((EclSourceViewer)sourceViewer, this.getConfiguredDocumentPartitioning(sourceViewer));
            MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
            reconciler.setIsAllowedToModifyDocument(false);
            reconciler.setDelay(500);
            return reconciler;
        }
        return super.getReconciler(sourceViewer);
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        return new MultipleHyperlinkPresenter(new RGB(0, 0, 255));
    }

    public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
        return SWT.MOD1;
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        if (this.textEditor == null) {
            return super.getHyperlinkDetectorTargets(sourceViewer);
        }
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.rcptt.ui.ecltexthyperlinkdetectortarget", this.textEditor);
        return targets;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        return this.getRegisteredHyperlinkDetectors(sourceViewer);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new EclFormattingStrategy());
        return formatter;
    }
}

