/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class TargetWeaver {
    private static String fgDevPropertiesURL = null;
    private static Properties fgDevProperties = null;

    static {
        if (Platform.inDevelopmentMode()) {
            fgDevPropertiesURL = System.getProperty("osgi.dev");
        }
    }

    private TargetWeaver() {
    }

    private static synchronized Properties getDevProperties() {
        if (fgDevPropertiesURL != null) {
            block13: {
                if (fgDevProperties == null) {
                    fgDevProperties = new Properties();
                    try {
                        File file;
                        URL url = new URL(fgDevPropertiesURL);
                        String path = url.getFile();
                        if (path == null || path.length() <= 0 || !(file = new File(path)).exists()) break block13;
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (FileInputStream stream = new FileInputStream(file);){
                            fgDevProperties.load(stream);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        PDECore.log(e);
                    }
                }
            }
            return fgDevProperties;
        }
        return null;
    }

    public static void weaveManifest(Map<String, String> manifest, File bundleLocation) {
        if (manifest != null && fgDevPropertiesURL != null) {
            Properties properties = TargetWeaver.getDevProperties();
            String id = manifest.get("Bundle-SymbolicName");
            String version = manifest.get("Bundle-Version");
            if (id != null && version != null) {
                String property;
                int index = id.indexOf(59);
                if (index != -1) {
                    id = id.substring(0, index);
                }
                if ((property = TargetWeaver.getDevProperty(bundleLocation.toPath(), id, version, properties)) != null) {
                    manifest.put("Bundle-ClassPath", property);
                }
            }
        }
    }

    static void weaveRunningPlatformDevProperties(Map<IPluginModelBase, String> launchDevProperties, Iterable<IPluginModelBase> launchedPlugins) {
        if (fgDevPropertiesURL != null) {
            Properties platformDevProperties = TargetWeaver.getDevProperties();
            for (IPluginModelBase launchedPlugin : launchedPlugins) {
                String devCP = TargetWeaver.getDevProperty(launchedPlugin, platformDevProperties);
                if (devCP == null) continue;
                launchDevProperties.put(launchedPlugin, devCP);
            }
        }
    }

    static String getWeavedSourceLibraryName(IPluginModelBase model, String libraryName) {
        if (fgDevPropertiesURL != null && !new File(libraryName).isAbsolute()) {
            String property;
            Properties properties = TargetWeaver.getDevProperties();
            String id = null;
            if (model.getBundleDescription() != null) {
                id = model.getBundleDescription().getSymbolicName();
            }
            if (id != null && (property = TargetWeaver.getDevProperty(model, properties)) != null) {
                return "";
            }
        }
        return libraryName;
    }

    private static String getDevProperty(IPluginModelBase plugin, Properties devProperties) {
        if (plugin.getUnderlyingResource() == null) {
            Path pluginLocation = Path.of(plugin.getInstallLocation(), new String[0]);
            IPluginBase pluginBase = plugin.getPluginBase();
            return TargetWeaver.getDevProperty(pluginLocation, pluginBase.getId(), pluginBase.getVersion(), devProperties);
        }
        return null;
    }

    private static String getDevProperty(Path bundleLocation, String id, String version, Properties devProperties) {
        String devCP = ClasspathHelper.getDevClasspath(devProperties, id, version);
        return devCP != null && TargetWeaver.isBundleOfRunningPlatform(bundleLocation, id, version) ? devCP : null;
    }

    private static boolean isBundleOfRunningPlatform(Path pluginLocation, String id, String version) {
        Bundle platformBundle = TargetWeaver.findRunningPlatformBundle(id, version);
        if (platformBundle != null) {
            try {
                Optional bundleFile = FileLocator.getBundleFileLocation((Bundle)platformBundle);
                return bundleFile.isPresent() && Files.isSameFile(pluginLocation, ((File)bundleFile.get()).toPath());
            }
            catch (IOException e) {
                PDECore.logException(e);
            }
        }
        return false;
    }

    private static Bundle findRunningPlatformBundle(String symbolicName, String versionStr) {
        Version version = Version.parseVersion((String)versionStr);
        Bundle[] platformBundles = Platform.getBundles((String)symbolicName, null);
        if (platformBundles == null) {
            return null;
        }
        return Arrays.stream(platformBundles).filter(b -> b.getVersion().equals((Object)version)).findAny().orElse(null);
    }
}

