/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IMatchRules;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.osgi.framework.VersionRange;
import org.w3c.dom.Node;

public class Fragment
extends PluginBase
implements IFragment {
    private static final long serialVersionUID = 1L;
    private String fPluginId = "";
    private String fPluginVersion = "";
    private int fMatchRule = 0;
    private boolean fPatch;

    public Fragment(boolean readOnly) {
        super(readOnly);
    }

    @Override
    public String getPluginId() {
        return this.fPluginId;
    }

    @Override
    public String getPluginVersion() {
        return this.fPluginVersion;
    }

    @Override
    public int getRule() {
        return this.fMatchRule;
    }

    @Override
    protected boolean hasRequiredAttributes() {
        if (this.fPluginId == null || this.fPluginVersion == null) {
            return false;
        }
        return super.hasRequiredAttributes();
    }

    @Override
    void load(BundleDescription bundleDescription, PDEState state) {
        HostSpecification host = bundleDescription.getHost();
        this.fPluginId = host.getName();
        org.eclipse.osgi.service.resolver.VersionRange versionRange = host.getVersionRange();
        if (versionRange != null) {
            this.fPluginVersion = versionRange.getLeft().toString();
            this.fMatchRule = PluginBase.getMatchRule((VersionRange)versionRange);
        }
        this.fPatch = state.isPatchFragment(bundleDescription.getBundleId());
        super.load(bundleDescription, state);
    }

    @Override
    void load(Node node, String schemaVersion) {
        this.fPluginId = this.getNodeAttribute(node, "plugin-id");
        this.fPluginVersion = this.getNodeAttribute(node, "plugin-version");
        String match = this.getNodeAttribute(node, "match");
        if (match != null) {
            String[] table = IMatchRules.RULE_NAME_TABLE;
            int i = 0;
            while (i < table.length) {
                if (match.equalsIgnoreCase(table[i])) {
                    this.fMatchRule = i;
                    break;
                }
                ++i;
            }
        }
        super.load(node, schemaVersion);
    }

    @Override
    public void reset() {
        this.fPluginId = "";
        this.fPluginVersion = "";
        this.fMatchRule = 0;
        super.reset();
    }

    @Override
    public void setPluginId(String newPluginId) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fPluginId;
        this.fPluginId = newPluginId;
        this.firePropertyChanged("plugin-id", oldValue, this.fPluginId);
    }

    @Override
    public void setPluginVersion(String newPluginVersion) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fPluginVersion;
        this.fPluginVersion = newPluginVersion;
        this.firePropertyChanged("plugin-version", oldValue, this.fPluginVersion);
    }

    @Override
    public void setRule(int rule) throws CoreException {
        this.ensureModelEditable();
        Integer oldValue = this.fMatchRule;
        this.fMatchRule = rule;
        this.firePropertyChanged("match", oldValue, rule);
    }

    @Override
    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("plugin-id")) {
            this.setPluginId(newValue != null ? newValue.toString() : null);
            return;
        }
        if (name.equals("plugin-version")) {
            this.setPluginVersion(newValue != null ? newValue.toString() : null);
            return;
        }
        if (name.equals("match")) {
            this.setRule((Integer)newValue);
            return;
        }
        super.restoreProperty(name, oldValue, newValue);
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        IPluginObject element;
        int n;
        int n2;
        IPluginObject[] iPluginObjectArray;
        String pver;
        String pid;
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (this.getSchemaVersion() != null) {
            writer.println("<?eclipse version=\"" + this.getSchemaVersion() + "\"?>");
        }
        writer.print("<fragment");
        if (this.getId() != null) {
            writer.println();
            writer.print("   id=\"" + this.getId() + "\"");
        }
        if (this.getName() != null) {
            writer.println();
            writer.print("   name=\"" + this.getWritableString(this.getName()) + "\"");
        }
        if (this.getVersion() != null) {
            writer.println();
            writer.print("   version=\"" + this.getVersion() + "\"");
        }
        if (this.getProviderName() != null) {
            writer.println();
            writer.print("   provider-name=\"" + this.getWritableString(this.getProviderName()) + "\"");
        }
        if ((pid = this.getPluginId()) != null && pid.length() > 0) {
            writer.println();
            writer.print("   plugin-id=\"" + this.getPluginId() + "\"");
        }
        if ((pver = this.getPluginVersion()) != null && pver.length() > 0) {
            writer.println();
            writer.print("   plugin-version=\"" + this.getPluginVersion() + "\"");
        }
        if (this.getRule() != 0) {
            writer.println();
            writer.print("   match=\"" + IMatchRules.RULE_NAME_TABLE[this.getRule()] + "\"");
        }
        writer.println(">");
        writer.println();
        String firstIndent = "   ";
        IPluginObject[] children = this.getLibraries();
        if (children.length > 0) {
            this.writeChildren(firstIndent, "runtime", children, writer);
            writer.println();
        }
        if ((children = this.getImports()).length > 0) {
            this.writeChildren(firstIndent, "requires", children, writer);
            writer.println();
        }
        if ((children = this.getExtensionPoints()).length > 0) {
            iPluginObjectArray = children;
            n2 = children.length;
            n = 0;
            while (n < n2) {
                element = iPluginObjectArray[n];
                ((IPluginExtensionPoint)element).write(firstIndent, writer);
                ++n;
            }
            writer.println();
        }
        iPluginObjectArray = children = this.getExtensions();
        n2 = children.length;
        n = 0;
        while (n < n2) {
            element = iPluginObjectArray[n];
            ((IPluginExtension)element).write(firstIndent, writer);
            ++n;
        }
        writer.println("</fragment>");
    }

    public boolean isPatch() {
        return this.fPatch;
    }
}

