/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class RemoteSelectionCombo
extends Composite {
    private static final int REMOTE_CONFIG_TEXT_MAX_LENGTH = 80;
    private SelectionType selectionType;
    private final Combo remoteCombo;
    private List<IRemoteSelectionListener> selectionListeners = new ArrayList<IRemoteSelectionListener>();
    private List<RemoteConfig> remoteConfigs;

    public RemoteSelectionCombo(Composite parent, int style, SelectionType selectionType) {
        super(parent, style);
        this.selectionType = selectionType;
        this.setLayout((Layout)new FillLayout());
        this.remoteCombo = new Combo((Composite)this, 12);
        this.remoteCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteConfig remoteConfig = RemoteSelectionCombo.this.getSelectedRemote();
                RemoteSelectionCombo.this.remoteSelected(remoteConfig);
            }
        });
    }

    public RemoteConfig setItems(List<RemoteConfig> remoteConfigs) {
        this.remoteConfigs = remoteConfigs;
        String[] items = new String[remoteConfigs.size()];
        int i = 0;
        for (RemoteConfig rc : remoteConfigs) {
            items[i++] = this.getTextForRemoteConfig(rc);
        }
        this.remoteCombo.setItems(items);
        RemoteConfig defaultRemoteConfig = this.getDefaultRemoteConfig();
        this.setSelectedRemote(defaultRemoteConfig);
        return defaultRemoteConfig;
    }

    public void addRemoteSelectionListener(IRemoteSelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public RemoteConfig getSelectedRemote() {
        int idx = this.remoteCombo.getSelectionIndex();
        if (this.remoteConfigs != null && idx != -1) {
            return this.remoteConfigs.get(idx);
        }
        return null;
    }

    public void setSelectedRemote(RemoteConfig remoteConfig) {
        int index = this.remoteConfigs.indexOf(remoteConfig);
        if (index != -1) {
            this.remoteCombo.select(index);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.remoteCombo.setEnabled(enabled);
    }

    private RemoteConfig getDefaultRemoteConfig() {
        if (this.remoteConfigs == null || this.remoteConfigs.isEmpty()) {
            return null;
        }
        for (RemoteConfig rc : this.remoteConfigs) {
            if (!"origin".equals(rc.getName())) continue;
            return rc;
        }
        return this.remoteConfigs.get(0);
    }

    private String getTextForRemoteConfig(RemoteConfig rc) {
        List uris;
        StringBuilder sb = new StringBuilder(rc.getName());
        sb.append(": ");
        boolean first = true;
        if (this.selectionType == SelectionType.FETCH) {
            uris = rc.getURIs();
        } else {
            uris = rc.getPushURIs();
            if (uris.isEmpty()) {
                uris = rc.getURIs();
            }
        }
        for (URIish u : uris) {
            String uString = u.toString();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
                if (sb.length() + uString.length() > 80) {
                    sb.append("...");
                    break;
                }
            }
            sb.append(uString);
        }
        return sb.toString();
    }

    private void remoteSelected(RemoteConfig remoteConfig) {
        for (IRemoteSelectionListener listener : this.selectionListeners) {
            listener.remoteSelected(remoteConfig);
        }
    }

    public static interface IRemoteSelectionListener {
        public void remoteSelected(RemoteConfig var1);
    }

    public static enum SelectionType {
        FETCH,
        PUSH;

    }
}

