/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.internal;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.bndtools.templating.Template;
import org.eclipse.core.runtime.AdapterTypes;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.bnd.ui.templating.RepoTemplateLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@AdapterTypes(adaptableClass={Template.class}, adapterNames={ILabelProvider.class, Image.class})
@Component
public class TemplateAdapter
implements IAdapterFactory {
    private final RepoTemplateLabelProvider labelProvider = new RepoTemplateLabelProvider();
    private ImageRegistry imageRegistry;

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof Template) {
            Template template = (Template)adaptableObject;
            if (adapterType == ILabelProvider.class) {
                return adapterType.cast((Object)this.labelProvider);
            }
            if (adapterType == Image.class) {
                String key;
                URI icon = template.getIcon();
                ImageRegistry registry = this.getImageRegistry();
                ImageDescriptor descriptor = registry.getDescriptor(key = icon.toASCIIString());
                if (descriptor == null) {
                    try {
                        registry.put(key, ImageDescriptor.createFromURL((URL)icon.toURL()));
                    }
                    catch (MalformedURLException e) {
                        return null;
                    }
                }
                return adapterType.cast(registry.get(key));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    void dispose() {
        this.labelProvider.dispose();
        TemplateAdapter templateAdapter = this;
        synchronized (templateAdapter) {
            if (this.imageRegistry != null) {
                this.imageRegistry.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageRegistry getImageRegistry() {
        TemplateAdapter templateAdapter = this;
        synchronized (templateAdapter) {
            if (this.imageRegistry == null) {
                this.imageRegistry = new ImageRegistry(Display.getCurrent());
            }
            return this.imageRegistry;
        }
    }
}

