/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewProjectCreationPage
extends WizardNewProjectCreationPage {
    protected Button fJavaButton;
    private final boolean fFragment;
    protected Label fSourceLabel;
    protected Text fSourceText;
    protected Label fOutputlabel;
    protected Text fOutputText;
    private final AbstractFieldData fData;
    protected Button fEclipseButton;
    protected Combo fOSGiCombo;
    protected Button fOSGIButton;
    private final IStructuredSelection fSelection;
    private static final String S_OSGI_PROJECT = "osgiProject";
    private static final String S_FRAMEWORK_TYPE = "frameworkType";
    private static final String S_AUTOMATIC_METADATA = "automaticMetadata";
    private Button useAutomaticMetadata;

    public NewProjectCreationPage(String pageName, AbstractFieldData data, boolean fragment, IStructuredSelection selection) {
        super(pageName);
        this.fFragment = fragment;
        this.fData = data;
        this.fSelection = selection;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        GridLayout layout = new GridLayout();
        control.setLayout((Layout)layout);
        this.createProjectTypeGroup(control);
        this.createFormatGroup(control);
        this.createWorkingSetGroup(control, this.fSelection, new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.pde.ui.pluginWorkingSet", "org.eclipse.ui.resourceWorkingSetPage"});
        this.updateRuntimeDependency();
        this.updateAutomatic();
        Dialog.applyDialogFont((Control)control);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)control, this.fFragment ? "org.eclipse.pde.doc.user.new_fragment_structure_page" : "org.eclipse.pde.doc.user.new_project_structure_page");
        this.setControl((Control)control);
    }

    protected void createProjectTypeGroup(Composite container) {
        Group group = new Group(container, 0);
        group.setText(PDEUIMessages.ProjectStructurePage_settings);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.fJavaButton = this.createButton((Composite)group, 32, 2, 0);
        this.fJavaButton.setText(PDEUIMessages.ProjectStructurePage_java);
        this.fJavaButton.setSelection(true);
        this.fJavaButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean enabled = this.fJavaButton.getSelection();
            this.fSourceLabel.setEnabled(enabled);
            this.fSourceText.setEnabled(enabled);
            this.fOutputlabel.setEnabled(enabled);
            this.fOutputText.setEnabled(enabled);
            this.setPageComplete(this.validatePage());
        }));
        this.fSourceLabel = this.createLabel((Composite)group, PDEUIMessages.ProjectStructurePage_source);
        this.fSourceText = this.createText((Composite)group);
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        this.fSourceText.setText(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName"));
        this.fOutputlabel = this.createLabel((Composite)group, PDEUIMessages.ProjectStructurePage_output);
        this.fOutputText = this.createText((Composite)group);
        this.fOutputText.setText(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
    }

    protected void createFormatGroup(Composite container) {
        Group group = new Group(container, 0);
        group.setText(PDEUIMessages.NewProjectCreationPage_target);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        if (this.fFragment) {
            label.setText(PDEUIMessages.NewProjectCreationPage_ftarget);
        } else {
            label.setText(PDEUIMessages.NewProjectCreationPage_ptarget);
        }
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        IDialogSettings settings = this.getDialogSettings();
        boolean osgiProject = settings == null ? false : settings.getBoolean(S_OSGI_PROJECT);
        boolean automaticMetadata = settings == null || settings.get(S_AUTOMATIC_METADATA) == null ? false : settings.getBoolean(S_AUTOMATIC_METADATA);
        String fwType = settings == null || settings.get(S_FRAMEWORK_TYPE) == null ? "Equinox" : settings.get(S_FRAMEWORK_TYPE);
        this.fEclipseButton = this.createButton((Composite)group, 16, 3, 30);
        this.fEclipseButton.setText(PDEUIMessages.NewProjectCreationPage_pDependsOnRuntime);
        this.fEclipseButton.setSelection(!osgiProject);
        this.fEclipseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateRuntimeDependency()));
        this.fOSGIButton = this.createButton((Composite)group, 16, 1, 30);
        this.fOSGIButton.setText(PDEUIMessages.NewProjectCreationPage_pPureOSGi);
        this.fOSGIButton.setSelection(osgiProject);
        this.fOSGiCombo = new Combo((Composite)group, 12);
        this.fOSGiCombo.setItems(new String[]{"Equinox", PDEUIMessages.NewProjectCreationPage_standard});
        this.fOSGiCombo.setText(fwType);
        this.useAutomaticMetadata = new Button((Composite)group, 32);
        this.useAutomaticMetadata.setText(PDEUIMessages.NewProjectCreationPage_automaticMetadataLabel);
        this.useAutomaticMetadata.setToolTipText(PDEUIMessages.NewProjectCreationPage_automaticMetadataTooltip);
        this.useAutomaticMetadata.setSelection(automaticMetadata);
        this.fOSGiCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateAutomatic()));
    }

    private void updateAutomatic() {
        boolean standardSelected = PDEUIMessages.NewProjectCreationPage_standard.equals(this.fOSGiCombo.getText());
        this.useAutomaticMetadata.setVisible(standardSelected);
    }

    private void updateRuntimeDependency() {
        boolean depends = this.fEclipseButton.getSelection();
        this.fOSGiCombo.setEnabled(!depends);
        this.useAutomaticMetadata.setEnabled(!depends);
    }

    private Button createButton(Composite container, int style, int span, int indent) {
        Button button = new Button(container, style);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.horizontalIndent = indent;
        button.setLayoutData((Object)gd);
        return button;
    }

    private Label createLabel(Composite container, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalIndent = 30;
        label.setLayoutData((Object)gd);
        return label;
    }

    private Text createText(Composite container) {
        Text text = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        text.setLayoutData((Object)gd);
        text.addModifyListener(e -> this.setPageComplete(this.validatePage()));
        return text;
    }

    public void updateData() {
        this.fData.setSimple(!this.fJavaButton.getSelection());
        this.fData.setSourceFolderName(this.fSourceText.getText().trim());
        this.fData.setOutputFolderName(this.fOutputText.getText().trim());
        this.fData.setLegacy(false);
        this.fData.setTargetVersion("3.8");
        this.fData.setHasBundleStructure(true);
        this.fData.setOSGiFramework(this.fOSGIButton.getSelection() ? this.fOSGiCombo.getText() : null);
        this.fData.setWorkingSets(this.getSelectedWorkingSets());
        this.fData.setAutomaticMetadataGeneration(this.useAutomaticMetadata.getSelection());
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        String name = this.getProjectName();
        if (name.indexOf(37) >= 0) {
            this.setErrorMessage(PDEUIMessages.NewProjectCreationPage_invalidProjectName);
            return false;
        }
        String location = this.getLocationPath().toString();
        if (location.indexOf(37) >= 0) {
            this.setErrorMessage(PDEUIMessages.NewProjectCreationPage_invalidLocationPath);
            return false;
        }
        if (this.fJavaButton != null && this.fJavaButton.getSelection()) {
            IStatus status;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject dmy = workspace.getRoot().getProject("project");
            if (this.fSourceText != null && this.fSourceText.getText().length() != 0 && !(status = workspace.validatePath(dmy.getFullPath().append(this.fSourceText.getText()).toString(), 2)).isOK()) {
                this.setErrorMessage(status.getMessage());
                return false;
            }
            if (this.fOutputText != null && this.fOutputText.getText().length() != 0 && !(status = workspace.validatePath(dmy.getFullPath().append(this.fOutputText.getText()).toString(), 2)).isOK()) {
                this.setErrorMessage(status.getMessage());
                return false;
            }
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void saveSettings(IDialogSettings settings) {
        settings.put(S_OSGI_PROJECT, !this.fEclipseButton.getSelection());
        settings.put(S_AUTOMATIC_METADATA, this.useAutomaticMetadata.getSelection());
        settings.put(S_FRAMEWORK_TYPE, this.fOSGiCombo.getText());
    }
}

