/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks.diagnostics;

import java.lang.ref.Cleaner;
import java.util.Map;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.ConcurrentCleaner;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalUseOnly
public class CleanerGraphQueryResult
implements GraphQueryResult {
    private static final Logger logger = LoggerFactory.getLogger(CleanerGraphQueryResult.class);
    private final GraphQueryResult delegate;
    private final Cleaner.Cleanable cleanable;
    private final CleanableState state;

    public CleanerGraphQueryResult(GraphQueryResult delegate, ConcurrentCleaner cleaner) {
        this.delegate = delegate;
        this.state = new CleanableState(delegate);
        this.cleanable = cleaner.register(this, this.state);
    }

    @Override
    public void close() {
        this.state.close();
        this.cleanable.clean();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public Statement next() {
        return (Statement)this.delegate.next();
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public Map<String, String> getNamespaces() throws QueryEvaluationException {
        return this.delegate.getNamespaces();
    }

    private static final class CleanableState
    implements Runnable {
        private final GraphQueryResult iteration;
        private boolean closed = false;

        public CleanableState(GraphQueryResult iteration) {
            this.iteration = iteration;
        }

        @Override
        public void run() {
            if (!this.closed) {
                try {
                    logger.warn("Forced closing of unclosed iteration. Set the system property 'org.eclipse.rdf4j.repository.debug' to 'true' to get stack traces.");
                    this.iteration.close();
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    throw new RuntimeException(e);
                }
            }
        }

        public void close() {
            this.closed = true;
            this.iteration.close();
        }
    }
}

