/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.FloatSets;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractFloatSet;

public abstract class AbstractImmutableFloatSet
extends AbstractFloatSet
implements ImmutableFloatSet {
    public ImmutableFloatSet newWith(float element) {
        return FloatHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableFloatSet newWithout(float element) {
        return FloatHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableFloatSet newWithAll(FloatIterable elements) {
        return FloatHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableFloatSet newWithoutAll(FloatIterable elements) {
        return FloatHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public FloatSet freeze() {
        return this;
    }

    public ImmutableFloatSet toImmutable() {
        return this;
    }

    public RichIterable<FloatIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)this);
            } else {
                FloatIterator iterator = this.floatIterator();
                while (iterator.hasNext()) {
                    MutableFloatSet batch = FloatSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

