/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.NotificationEmitter;
import javax.management.openmbean.CompositeData;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.AbstractModel;
import org.eclipse.rdf4j.model.impl.FilteredModel;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalUseOnly
public abstract class AbstractMemoryOverflowModel<T extends AbstractModel>
extends AbstractModel {
    private static final long serialVersionUID = 4119844228099208169L;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    public static int BATCH_SIZE = 1024;
    public static int MEMORY_THRESHOLD_HIGH = 300;
    public static int MEMORY_THRESHOLD_MEDIUM = 200;
    public static int MEMORY_THRESHOLD_LOW = 100;
    private static volatile boolean overflow;
    public static int MIN_AVAILABLE_MEM_BEFORE_OVERFLOWING;
    static final Logger logger;
    private volatile LinkedHashModel memory;
    protected volatile transient T disk;
    private final SimpleValueFactory vf = SimpleValueFactory.getInstance();
    private static final int[] GC_LOAD;
    private static int prevBucket;
    private static volatile boolean highGcLoad;
    private static final Queue<GcInfo> gcInfos;
    private static volatile boolean lowMemLowGcSum;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile boolean closed;

    private static double mbFree() {
        long maxMemory = RUNTIME.maxMemory();
        long totalMemory = RUNTIME.totalMemory();
        long freeMemory = RUNTIME.freeMemory();
        long used = totalMemory - freeMemory;
        long freeToAllocateMemory = maxMemory - used;
        return (double)freeToAllocateMemory / 1024.0 / 1024.0;
    }

    public AbstractMemoryOverflowModel() {
        this.memory = new LinkedHashModel();
    }

    public AbstractMemoryOverflowModel(Set<Namespace> namespaces) {
        this.memory = new LinkedHashModel(namespaces, 0);
    }

    public synchronized Set<Namespace> getNamespaces() {
        return this.memory.getNamespaces();
    }

    public synchronized Optional<Namespace> getNamespace(String prefix) {
        return this.memory.getNamespace(prefix);
    }

    public synchronized Namespace setNamespace(String prefix, String name) {
        return this.memory.setNamespace(prefix, name);
    }

    public void setNamespace(Namespace namespace) {
        this.memory.setNamespace(namespace);
    }

    public synchronized Optional<Namespace> removeNamespace(String prefix) {
        return this.memory.removeNamespace(prefix);
    }

    public boolean contains(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return this.getDelegate().contains(subj, pred, obj, contexts);
    }

    public boolean add(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        this.checkMemoryOverflow();
        return this.getDelegate().add(subj, pred, obj, contexts);
    }

    @Override
    public boolean add(Statement st) {
        this.checkMemoryOverflow();
        return this.getDelegate().add((Object)st);
    }

    @Override
    public boolean addAll(Collection<? extends Statement> c) {
        this.checkMemoryOverflow();
        if (this.disk != null || c.size() <= BATCH_SIZE) {
            return this.getDelegate().addAll(c);
        }
        boolean ret = false;
        HashSet<Statement> buffer = new HashSet<Statement>();
        for (Statement statement : c) {
            buffer.add(statement);
            if (buffer.size() < BATCH_SIZE) continue;
            ret |= this.getDelegate().addAll(buffer);
            buffer.clear();
            this.checkMemoryOverflow();
        }
        if (!buffer.isEmpty()) {
            ret |= this.getDelegate().addAll(buffer);
            buffer.clear();
        }
        return ret;
    }

    public boolean remove(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return this.getDelegate().remove(subj, pred, obj, contexts);
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.getDelegate().iterator();
    }

    @Override
    public boolean clear(Resource ... contexts) {
        return this.getDelegate().clear(contexts);
    }

    public Model filter(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return new FilteredModel(this, subj, pred, obj, contexts){
            private static final long serialVersionUID = -475666402618133101L;

            @Override
            public int size() {
                return AbstractMemoryOverflowModel.this.getDelegate().filter(this.subj, this.pred, this.obj, this.contexts).size();
            }

            @Override
            public Iterator<Statement> iterator() {
                return AbstractMemoryOverflowModel.this.getDelegate().filter(this.subj, this.pred, this.obj, this.contexts).iterator();
            }

            @Override
            protected void removeFilteredTermIteration(Iterator<Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
                AbstractMemoryOverflowModel.this.removeTermIteration(iter, subj, pred, obj, contexts);
            }
        };
    }

    @Override
    public synchronized void removeTermIteration(Iterator<Statement> iter, Resource subj, IRI pred, Value obj, Resource ... contexts) {
        if (this.disk == null) {
            this.memory.removeTermIteration((Iterator)iter, subj, pred, obj, contexts);
        } else {
            ((AbstractModel)this.disk).removeTermIteration(iter, subj, pred, obj, contexts);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model getDelegate() {
        LinkedHashModel memory = this.memory;
        if (memory != null) {
            return memory;
        }
        T disk = this.disk;
        if (disk != null) {
            return disk;
        }
        try {
            this.lock.lockInterruptibly();
            try {
                if (this.memory != null) {
                    LinkedHashModel linkedHashModel = this.memory;
                    return linkedHashModel;
                }
                if (this.disk != null) {
                    T t = this.disk;
                    return t;
                }
                if (!this.closed) throw new IllegalStateException("MemoryOverflowModel is in an inconsistent state");
                throw new IllegalStateException("MemoryOverflowModel is closed");
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Model delegate = this.getDelegate();
        s.writeInt(delegate.size());
        for (Statement st : delegate) {
            Resource subj = st.getSubject();
            IRI pred = st.getPredicate();
            Value obj = st.getObject();
            Resource ctx = st.getContext();
            s.writeObject(this.vf.createStatement(subj, pred, obj, ctx));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            this.add((Statement)s.readObject());
        }
    }

    private synchronized void checkMemoryOverflow() {
        try {
            this.lock.lockInterruptibly();
            try {
                if (this.disk == this.getDelegate()) {
                    return;
                }
                if (overflow || highGcLoad) {
                    logger.debug("Syncing triples to disk due to gc load");
                    this.overflowToDisk();
                    if (!highGcLoad) {
                        overflow = false;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private synchronized void overflowToDisk() {
        try {
            this.lock.lockInterruptibly();
            try {
                overflow = true;
                if (this.memory == null) {
                    assert (this.disk != null);
                    return;
                }
                LinkedHashModel memory = this.memory;
                this.memory = null;
                this.overflowToDiskInner(memory);
                logger.debug("overflow synced to disk");
                System.gc();
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected abstract void overflowToDiskInner(Model var1);

    static {
        MIN_AVAILABLE_MEM_BEFORE_OVERFLOWING = RUNTIME.maxMemory() >= 0x40000000L ? 128 : 32;
        logger = LoggerFactory.getLogger(AbstractMemoryOverflowModel.class);
        GC_LOAD = new int[10];
        highGcLoad = false;
        gcInfos = new ConcurrentLinkedQueue<GcInfo>();
        lowMemLowGcSum = false;
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            NotificationEmitter emitter = (NotificationEmitter)((Object)gcBean);
            emitter.addNotificationListener((notification, o) -> {
                GcInfo poll;
                long currentBucket = System.currentTimeMillis() / 100L % 10L;
                while (currentBucket != (long)prevBucket) {
                    prevBucket = (prevBucket + 1) % 10;
                    AbstractMemoryOverflowModel.GC_LOAD[AbstractMemoryOverflowModel.prevBucket] = 0;
                }
                while ((poll = gcInfos.poll()) != null) {
                    int n = (int)currentBucket;
                    GC_LOAD[n] = GC_LOAD[n] + (int)poll.getDuration();
                }
                GarbageCollectionNotificationInfo gcNotificationInfo = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
                GcInfo gcInfo = gcNotificationInfo.getGcInfo();
                gcInfos.add(gcInfo);
                long gcSum = 0L;
                long gcMax = 0L;
                for (int i : GC_LOAD) {
                    gcSum += (long)i;
                    if ((long)i <= gcMax) continue;
                    gcMax = i;
                }
                if ((double)gcSum < (double)gcMax * 1.3) {
                    gcSum -= gcMax / 2L;
                }
                double v = AbstractMemoryOverflowModel.mbFree();
                if (!highGcLoad && !lowMemLowGcSum && v < (double)MIN_AVAILABLE_MEM_BEFORE_OVERFLOWING && gcSum < (long)MEMORY_THRESHOLD_LOW) {
                    lowMemLowGcSum = true;
                    return;
                }
                lowMemLowGcSum = false;
                if (!highGcLoad && v < 256.0 && (gcSum > (long)MEMORY_THRESHOLD_HIGH || v < (double)MIN_AVAILABLE_MEM_BEFORE_OVERFLOWING)) {
                    logger.debug("High GC load detected. Free memory: {} MB, GC sum: {} ms in past 1000 ms", (Object)v, (Object)gcSum);
                    highGcLoad = true;
                } else if ((v > 256.0 || gcSum < (long)MEMORY_THRESHOLD_MEDIUM) && highGcLoad && v > (double)MIN_AVAILABLE_MEM_BEFORE_OVERFLOWING) {
                    logger.debug("GC load back to normal. Free memory: {} MB, GC sum: {} ms in past 1000 ms", (Object)v, (Object)gcSum);
                    highGcLoad = false;
                }
            }, null, null);
        }
    }
}

