/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.factor.arraywrapper;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.recommenders.internal.jayes.util.ArrayUtils;
import org.eclipse.recommenders.jayes.factor.arraywrapper.IArrayWrapper;

public class FloatArrayWrapper
implements IArrayWrapper {
    private float[] array;

    public FloatArrayWrapper(float ... array) {
        this.array = array;
    }

    @Override
    public void setArray(double ... array) {
        this.setArray(ArrayUtils.toFloatArray(array));
    }

    @Override
    public void setArray(float ... array) {
        this.array = array;
    }

    @Override
    public double[] toDoubleArray() {
        return ArrayUtils.toDoubleArray(this.array);
    }

    @Override
    public float[] toFloatArray() {
        return this.array;
    }

    @Override
    public void set(int index, double d) {
        this.array[index] = (float)d;
    }

    @Override
    public void set(int index, float d) {
        this.array[index] = d;
    }

    @Override
    public void mulAssign(int index, double d) {
        int n = index;
        this.array[n] = this.array[n] * (float)d;
    }

    @Override
    public void mulAssign(int index, float d) {
        int n = index;
        this.array[n] = this.array[n] * d;
    }

    @Override
    public void mulAssign(int index, IArrayWrapper arg, int argIndex) {
        int n = index;
        this.array[n] = this.array[n] * arg.getFloat(argIndex);
    }

    @Override
    public void addAssign(int index, double d) {
        int n = index;
        this.array[n] = this.array[n] + (float)d;
    }

    @Override
    public void addAssign(int index, float d) {
        int n = index;
        this.array[n] = this.array[n] + d;
    }

    @Override
    public void addAssign(int index, IArrayWrapper arg, int argIndex) {
        int n = index;
        this.array[n] = this.array[n] + arg.getFloat(argIndex);
    }

    @Override
    public double getDouble(int index) {
        return this.array[index];
    }

    @Override
    public float getFloat(int index) {
        return this.array[index];
    }

    @Override
    public int length() {
        return this.array.length;
    }

    @Override
    public void copy(double ... array) {
        this.setArray(array);
    }

    @Override
    public void copy(float ... array) {
        this.array = (float[])array.clone();
    }

    @Override
    public void copy(IArrayWrapper array) {
        this.copy(array.toFloatArray());
    }

    @Override
    public void fill(double d) {
        Arrays.fill(this.array, (float)d);
    }

    @Override
    public void fill(float d) {
        Arrays.fill(this.array, d);
    }

    @Override
    public void arrayCopy(IArrayWrapper src, int srcOffset, int destOffset, int length) {
        System.arraycopy(src.toFloatArray(), srcOffset, this.array, destOffset, length);
    }

    @Override
    public void newArray(int capacity) {
        this.array = new float[capacity];
    }

    @Override
    public FloatArrayWrapper clone() {
        try {
            FloatArrayWrapper clone = (FloatArrayWrapper)super.clone();
            clone.array = (float[])this.array.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)"This should not happen");
        }
    }

    @Override
    public int sizeOfElement() {
        return 4;
    }

    @Override
    public Iterator<Number> iterator() {
        return new Iterator<Number>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < FloatArrayWrapper.this.array.length;
            }

            @Override
            public Number next() {
                ++this.index;
                return Float.valueOf(FloatArrayWrapper.this.array[this.index - 1]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

