/**
 * Copyright (c) 2010, 2013 Darmstadt University of Technology.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Andreas Sewe - initial API and implementation.
 */
package org.eclipse.recommenders.livedoc.cli.args4j;

import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class ArtifactOptionHandler extends OptionHandler<Artifact> {

    public ArtifactOptionHandler(CmdLineParser owner, OptionDef option, Setter<? super Artifact> setter) {
        super(owner, option, setter);
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        String param = params.getParameter(0);
        try {
            setter.addValue(new DefaultArtifact(param));
            return 1;
        } catch (IllegalArgumentException e) {
            throw new CmdLineException(owner, e.getMessage(), e);
        }
    }

    @Override
    public String getDefaultMetaVariable() {
        return "COORDINATE";
    }
}
